/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.client.ShaderEffectRenderCallback;
import com.github.thedeathlycow.scorchful.client.ShaderStatusEffectManager;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2718;
import net.minecraft.class_2783;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public final class ShaderStatusEffectManagers {
    private static final List<ShaderStatusEffectManager> TRACKED_MANAGERS = new ArrayList<ShaderStatusEffectManager>(2);
    private static final ShaderStatusEffectManager HEAT_STROKE = ShaderStatusEffectManagers.createAndTrack(Scorchful.id("heat_stroke"), SStatusEffects.HEAT_STROKE, ClientConfig::enableHeatStrokePostProcessing);
    private static final ShaderStatusEffectManager FEAR = ShaderStatusEffectManagers.createAndTrack(Scorchful.id("fear"), SStatusEffects.FEAR, ClientConfig::enableFearPostProcessing);

    public static void initialize() {
        ShaderStatusEffectManagers.getTrackedManagers().forEach(manager -> {
            ShaderEffectRenderCallback.EVENT.register(manager);
            ClientPlayConnectionEvents.DISCONNECT.register(manager);
        });
    }

    public static List<ShaderStatusEffectManager> getTrackedManagers() {
        return TRACKED_MANAGERS;
    }

    public static void onEffectAdded(class_2783 packet, class_638 world) {
        class_746 player;
        class_1297 entity = world.method_8469(packet.method_11943());
        if (entity instanceof class_746 && (player = (class_746)entity).method_7340()) {
            class_6880 potionEffect = packet.method_11946();
            ShaderStatusEffectManagers.getTrackedManagers().forEach(manager -> manager.onEffectAdded((class_6880<class_1291>)potionEffect));
        }
    }

    public static void onEffectRemoved(class_2718 packet, class_638 world) {
        class_746 player;
        class_1297 entity = packet.method_11767((class_1937)world);
        if (entity instanceof class_746 && (player = (class_746)entity).method_7340()) {
            class_6880 potionEffect = packet.comp_2176();
            ShaderStatusEffectManagers.getTrackedManagers().forEach(manager -> manager.onEffectRemoved((class_6880<class_1291>)potionEffect));
        }
    }

    public static void onPlayerRespawn() {
        ShaderStatusEffectManagers.getTrackedManagers().forEach(ShaderStatusEffectManager::onPlayerRespawn);
    }

    public static ShaderStatusEffectManager createAndTrack(class_2960 shaderID, class_6880<class_1291> potionEffect, Predicate<ClientConfig> enabledPredicate) {
        ShaderStatusEffectManager statusEffectShader = new ShaderStatusEffectManager(shaderID, potionEffect, enabledPredicate);
        TRACKED_MANAGERS.add(statusEffectShader);
        return statusEffectShader;
    }

    private ShaderStatusEffectManagers() {
    }
}

