/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.components;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.event.HeatVisionActivation;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.temperature.heatvision.HeatVision;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class EntityDesertVisionComponent
implements Component,
AutoSyncedComponent,
ServerTickingComponent {
    private final class_1297 provider;
    @Nullable
    private class_1657 cause;
    @Nullable
    private HeatVision vision;
    private int timeToLive = 600;

    public EntityDesertVisionComponent(class_1297 provider) {
        this.provider = provider;
    }

    public boolean hasDesertVision() {
        return this.cause != null;
    }

    public void applyDesertVision(@NotNull HeatVision vision, @NotNull class_1657 cause) {
        this.cause = cause;
        this.vision = vision;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        buf.method_37435(Optional.ofNullable(this.cause), (pBuf, player) -> pBuf.method_10797(player.method_5667()));
        Scorchful.LOGGER.debug("Writing sync packet to entity desert vision");
    }

    public void applySyncPacket(class_9129 buf) {
        UUID uuid = buf.method_37436(class_2540::method_56344).orElse(null);
        this.cause = uuid != null ? this.provider.method_37908().method_18470(uuid) : null;
        Scorchful.LOGGER.debug("Applying sync packet to entity desert vision");
    }

    public void serverTick() {
        if (!this.tickCanLive()) {
            Scorchful.LOGGER.debug("Discarding entity desert vision {}", (Object)this.provider);
            this.provider.method_31472();
        }
    }

    public class_1657 getCause() {
        return this.cause;
    }

    private boolean tickCanLive() {
        if (this.cause == null) {
            return true;
        }
        if (this.timeToLive-- <= 0) {
            return false;
        }
        double activationDistance = 16.0;
        if (this.provider.method_5858((class_1297)this.cause) < activationDistance) {
            ((HeatVisionActivation)HeatVisionActivation.EVENT.invoker()).onActivated(this.vision, (class_3218)this.provider.method_37908(), this.provider.method_24515(), this.cause);
            return false;
        }
        return this.cause.method_6059(SStatusEffects.HEAT_STROKE);
    }
}

