/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.hud;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public final class SoakingUnderlay
implements StatusBarOverlayRenderEvents.RenderHealthBarCallback {
    public static final SoakingUnderlay INSTANCE = new SoakingUnderlay();
    public static final class_2960 TEXTURE = Scorchful.id("textures/gui/soaking_overlay.png");
    public static final int TEXTURE_WIDTH = 9;
    public static final int TEXTURE_HEIGHT = 10;

    public void render(class_332 context, class_1657 player, Vector2i[] heartPositions, int displayHealth, int maxDisplayHealth) {
        if (!Scorchful.getConfig().clientConfig.doSoakingOverlay() || !player.thermoo$isWet()) {
            return;
        }
        int burningHealthPoints = SoakingUnderlay.getNumBurningPoints(player, maxDisplayHealth);
        int burningHealthHearts = SoakingUnderlay.getNumBurningHeartsFromPoints(burningHealthPoints);
        for (int i = 0; i < burningHealthHearts; ++i) {
            Vector2i pos = heartPositions[i];
            if (pos == null) continue;
            boolean isHalfHeart = i + 1 >= burningHealthHearts && (burningHealthPoints & 1) == 1;
            int width = isHalfHeart ? 5 : 9;
            context.method_25290(class_1921::method_62277, TEXTURE, pos.x, pos.y - 1, 0.0f, 0.0f, width, 10, 9, 10);
        }
    }

    private static int getNumBurningPoints(@NotNull class_1657 player, int maxDisplayHealth) {
        float overheatProgress = player.thermoo$getSoakedScale();
        return class_3532.method_15386((float)(overheatProgress * (float)maxDisplayHealth));
    }

    private static int getNumBurningHeartsFromPoints(int burningPoints) {
        return class_3532.method_15386((float)((float)burningPoints / 2.0f));
    }

    private SoakingUnderlay() {
    }
}

