/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.command;

import com.github.thedeathlycow.thermoo.api.command.TemperatureUnitArgumentType;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentLookup;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentManager;
import com.github.thedeathlycow.thermoo.api.util.TemperatureConverter;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import com.github.thedeathlycow.thermoo.impl.LivingEntityTickUtil;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.github.thedeathlycow.thermoo.impl.environment.EnvironmentTickContextImpl;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Contract;

public class EnvironmentCommand {
    public static final Supplier<LiteralArgumentBuilder<class_2168>> COMMAND_BUILDER = EnvironmentCommand::buildCommand;

    @Contract(value="->new")
    private static LiteralArgumentBuilder<class_2168> buildCommand() {
        LiteralArgumentBuilder printController = (LiteralArgumentBuilder)class_2170.method_9247((String)"printcontroller").executes(context -> EnvironmentCommand.printController((class_2168)context.getSource()));
        LiteralArgumentBuilder checkTemperature = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"checktemperature").executes(context -> {
            class_243 pos = ((class_2168)context.getSource()).method_9222();
            return EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350));
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target").method_24515()))).then(class_2170.method_9244((String)"unit", (ArgumentType)TemperatureUnitArgumentType.temperatureUnit()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2186.method_9313((CommandContext)context, (String)"target").method_24515(), TemperatureUnitArgumentType.getTemperatureUnit((CommandContext<class_2168>)context, "unit")))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"location", (ArgumentType)class_2262.method_9698()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location")))).then(class_2170.method_9244((String)"unit", (ArgumentType)TemperatureUnitArgumentType.temperatureUnit()).executes(context -> EnvironmentCommand.executeCheckTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), TemperatureUnitArgumentType.getTemperatureUnit((CommandContext<class_2168>)context, "unit")))));
        String location = "location";
        String target = "target";
        String unit = "unit";
        String scale = "scale";
        TemperatureUnit fallbackUnit = TemperatureUnit.CELSIUS;
        double fallbackTempScale = 1.0;
        LiteralArgumentBuilder temperature = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"temperature").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> EnvironmentCommand.executeEntityTemperature((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"location", (ArgumentType)class_2262.method_9698()).executes(context -> EnvironmentCommand.executeTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), TemperatureUnit.CELSIUS, 1.0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"unit", (ArgumentType)TemperatureUnitArgumentType.temperatureUnit()).executes(context -> EnvironmentCommand.executeTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), TemperatureUnitArgumentType.getTemperatureUnit((CommandContext<class_2168>)context, "unit"), 1.0))).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> EnvironmentCommand.executeTemperature((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), TemperatureUnitArgumentType.getTemperatureUnit((CommandContext<class_2168>)context, "unit"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))));
        double fallbackHumidityScale = 100.0;
        LiteralArgumentBuilder relativeHumidity = (LiteralArgumentBuilder)class_2170.method_9247((String)"relativehumidity").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"location", (ArgumentType)class_2262.method_9698()).executes(context -> EnvironmentCommand.executeRelativeHumidity((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), 100.0))).then(class_2170.method_9244((String)"scale", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> EnvironmentCommand.executeRelativeHumidity((class_2168)context.getSource(), class_2262.method_9696((CommandContext)context, (String)"location"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))));
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"thermoo").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"environment").requires(src -> src.method_9259(2))).then((ArgumentBuilder)checkTemperature)).then((ArgumentBuilder)printController)).then((ArgumentBuilder)temperature)).then((ArgumentBuilder)relativeHumidity));
    }

    @Deprecated
    private static int printController(class_2168 source) {
        String controller = EnvironmentManager.INSTANCE.getController().toString();
        source.method_9226(() -> class_2561.method_48321((String)"commands.thermoo.environment.printcontroller.success", (String)"Controller logged to console"), false);
        source.method_9226(() -> class_2561.method_48321((String)"commands.thermoo.environment.printcontroller.deprecation", (String)"This command is deprecated, the Environment Controller has been replaced with the Environment Datapack Registry.").method_27692(class_124.field_1061), false);
        Thermoo.LOGGER.info("The current controller is: {}", (Object)controller);
        return 0;
    }

    private static int executeEntityTemperature(class_2168 source, class_3222 target) {
        double resistance;
        class_2338 pos = LivingEntityTickUtil.getTemperatureTickPos((class_1309)target);
        EnvironmentTickContextImpl<class_3222> context = new EnvironmentTickContextImpl<class_3222>(target, target.method_51469(), pos, EnvironmentLookup.getInstance().findEnvironmentComponents((class_1937)target.method_51469(), pos));
        int tempChange = ((ServerPlayerEnvironmentTickEvents.GetTemperatureChange)ServerPlayerEnvironmentTickEvents.GET_TEMPERATURE_CHANGE.invoker()).addPointChange(context);
        double d = tempChange != 0 ? (tempChange > 0 ? target.thermoo$getEnvironmentHeatResistance() : target.thermoo$getEnvironmentColdResistance()) : (resistance = 0.0);
        if (resistance >= 0.0) {
            source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.environment.temperature.player.success", (String)"The environment temperature change of %s is %s (with a %s chance to dodge)", (Object[])new Object[]{target.method_5476(), tempChange, "%.2f%%".formatted(resistance * 100.0)}), false);
        } else {
            source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.environment.temperature.player.negative.success", (String)"The environment temperature change of %s is %s (with a %s chance of doubling)", (Object[])new Object[]{target.method_5476(), tempChange, "%.2f%%".formatted(resistance * -100.0)}), false);
        }
        return tempChange;
    }

    private static int executeTemperature(class_2168 source, class_2338 location, TemperatureUnit unit, double scale) {
        double temperature = ((TemperatureRecord)EnvironmentLookup.getInstance().findEnvironmentComponents((class_1937)source.method_9225(), location).method_57830(EnvironmentComponentTypes.TEMPERATURE, (Object)TemperatureRecordComponent.DEFAULT)).valueInUnit(unit);
        source.method_9226(() -> {
            class_5321 biome = source.method_9225().method_23753(location).method_40230().orElse(null);
            return class_2561.method_48322((String)"commands.thermoo.environment.temperature.success", (String)"The environment temperature at %s, %s, %s (%s) is %s\u00b0%s", (Object[])new Object[]{location.method_10263(), location.method_10264(), location.method_10260(), biome == null ? "unknown" : biome.method_29177().toString(), String.format("%.2f", temperature), unit.getUnitSymbol()});
        }, false);
        return (int)(temperature * scale);
    }

    private static int executeRelativeHumidity(class_2168 source, class_2338 location, double scale) {
        double relativeHumidity = (Double)EnvironmentLookup.getInstance().findEnvironmentComponents((class_1937)source.method_9225(), location).method_57830(EnvironmentComponentTypes.RELATIVE_HUMIDITY, (Object)0.5);
        double scaledHumidity = relativeHumidity * scale;
        source.method_9226(() -> {
            class_5321 biome = source.method_9225().method_23753(location).method_40230().orElse(null);
            return class_2561.method_48322((String)"commands.thermoo.environment.humidity.success", (String)"The environmental relative humidity at %s, %s, %s (%s) is %s%", (Object[])new Object[]{location.method_10263(), location.method_10264(), location.method_10260(), biome == null ? "unknown" : biome.method_29177().toString(), String.format("%.2f", scaledHumidity)});
        }, false);
        return (int)scaledHumidity;
    }

    @Deprecated
    private static int executeCheckTemperature(class_2168 source, class_2338 location) {
        int temperatureChange = EnvironmentManager.INSTANCE.getController().getLocalTemperatureChange((class_1937)source.method_9225(), location);
        class_5321 biome = source.method_9225().method_23753(location).method_40230().orElse(null);
        source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.environment.checktemperature.success", (String)"The passive temperature change at %s, %s, %s (%s) is %s", (Object[])new Object[]{location.method_10263(), location.method_10264(), location.method_10260(), biome == null ? "unknown" : biome.method_29177().toString(), temperatureChange}), false);
        source.method_9226(() -> class_2561.method_48321((String)"commands.thermoo.environment.checktemperature.deprecation", (String)"This command is deprecated, use /thermoo environment temperature <pos>").method_27692(class_124.field_1061), false);
        return temperatureChange;
    }

    @Deprecated
    private static int executeCheckTemperature(class_2168 source, class_2338 location, TemperatureUnit unit) {
        int temperatureTick = EnvironmentManager.INSTANCE.getController().getLocalTemperatureChange((class_1937)source.method_9225(), location);
        class_5321 biome = source.method_9225().method_23753(location).method_40230().orElse(null);
        double temperature = TemperatureConverter.temperatureTickToAmbientTemperature(temperatureTick, new TemperatureConverter.Settings(unit, 1.0, 0.0));
        source.method_9226(() -> class_2561.method_48322((String)"commands.thermoo.environment.checktemperature.unit.success", (String)"The temperature at %s, %s, %s (%s) is %s\u00b0%s", (Object[])new Object[]{location.method_10263(), location.method_10264(), location.method_10260(), biome == null ? "unknown" : biome.method_29177().toString(), String.format("%.2f", temperature), unit.getUnitSymbol()}), false);
        source.method_9226(() -> class_2561.method_48321((String)"commands.thermoo.environment.checktemperature.deprecation", (String)"This command is deprecated, use /thermoo environment temperature <pos>").method_27692(class_124.field_1061), false);
        return (int)temperature;
    }
}

