/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl.environment;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentDefinition;
import com.github.thedeathlycow.thermoo.api.environment.EnvironmentLookup;
import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

public class EnvironmentLookupImpl
implements EnvironmentLookup {
    public static final EnvironmentLookupImpl INSTANCE = new EnvironmentLookupImpl();
    private final Map<class_5321<class_1959>, List<class_6880<EnvironmentProvider>>> biomeProviderCache = new IdentityHashMap<class_5321<class_1959>, List<class_6880<EnvironmentProvider>>>();

    public static void initialize() {
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> INSTANCE.clearCache());
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, resourceManager) -> INSTANCE.clearCache());
    }

    @Override
    public class_9323 findEnvironmentComponents(class_1937 world, class_2338 pos) {
        class_6880 biome = world.method_23753(pos);
        return this.findEnvironmentComponentsForBiome(world, pos, (class_6880<class_1959>)biome);
    }

    public class_9323 findEnvironmentComponentsForBiome(class_1937 world, class_2338 pos, class_6880<class_1959> biome) {
        class_9323.class_9324 builder = class_9323.method_57827();
        for (class_6880<EnvironmentProvider> provider : this.getProviders(biome, world.method_30349())) {
            ((EnvironmentProvider)provider.comp_349()).buildCurrentComponents(world, pos, biome, builder);
        }
        return builder.method_57838();
    }

    private List<class_6880<EnvironmentProvider>> getProviders(class_6880<class_1959> biome, class_5455 manager) {
        class_5321 key = biome.method_40230().orElse(null);
        if (key == null) {
            return Collections.emptyList();
        }
        return this.biomeProviderCache.computeIfAbsent((class_5321<class_1959>)key, k -> {
            List<class_6880> providers = manager.method_30530(ThermooRegistryKeys.ENVIRONMENT).method_10220().filter(definition -> definition.providesFor(biome)).map(EnvironmentDefinition::provider).toList();
            if (Thermoo.LOGGER.isDebugEnabled()) {
                Thermoo.LOGGER.debug("Environment providers found for {}: {}", k, providers.stream().map(class_6880::method_40230).filter(Optional::isPresent).map(ek -> ((class_5321)ek.orElseThrow()).method_29177()).toList());
            }
            return providers;
        });
    }

    private void clearCache() {
        this.biomeProviderCache.clear();
        Thermoo.LOGGER.debug("Environment lookup cache cleared");
    }
}

