/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import com.github.thedeathlycow.scorchful.components.PlayerWaterComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.item.component.DrinkLevelComponent;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public abstract class DrinkItem
extends class_1792 {
    public static final int DRINK_TIME_TICKS = 32;
    private static final int START_DRINK_PARTICLES = 22;

    public DrinkItem(class_1792.class_1793 settings) {
        super(settings);
    }

    protected abstract class_1799 getPostConsumeStack(class_1799 var1, class_1937 var2, class_3222 var3);

    public class_1799 method_7854() {
        class_1799 itemStack = super.method_7854();
        itemStack.method_57379(SDataComponentTypes.DRINK_LEVEL, (Object)DrinkLevelComponent.HYDRATING);
        return itemStack;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        if (world.field_9236 && remainingUseTicks < 22) {
            DrinkItem.spawnWaterParticles(world, user, 2);
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        user.method_32876((class_6880)class_5712.field_28734);
        if (user instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)user;
            class_174.field_1198.method_8821(serverPlayer, stack);
            serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            return this.getPostConsumeStack(super.method_7861(stack, world, user), world, serverPlayer);
        }
        return super.method_7861(stack, world, user);
    }

    public static void applyWater(class_1799 stack, class_3222 player) {
        if (ServerThirstPlugin.isCustomPluginLoaded()) {
            return;
        }
        DrinkLevelComponent drink = (DrinkLevelComponent)((Object)stack.method_57824(SDataComponentTypes.DRINK_LEVEL));
        if (drink == null) {
            return;
        }
        PlayerWaterComponent component = (PlayerWaterComponent)ScorchfulComponents.PLAYER_WATER.get((Object)player);
        int water = drink.getDrinkingWater(Scorchful.getConfig().thirstConfig);
        component.drink(water);
        if ((double)component.getWaterDrunk() >= 270.0) {
            player.method_5783(SSoundEvents.ENTITY_GULP, 1.0f, 1.0f);
        }
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 32;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    private static void spawnWaterParticles(class_1937 world, class_1309 entity, int count) {
        class_5819 random = entity.method_59922();
        for (int i = 0; i < count; ++i) {
            class_243 velocity = new class_243(((double)random.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 1.0, 0.0);
            velocity = velocity.method_1037(-entity.method_36455() * ((float)Math.PI / 180));
            velocity = velocity.method_1024(-entity.method_36454() * ((float)Math.PI / 180));
            double y = (double)(-random.method_43057()) * 0.6 - 0.3;
            class_243 postion = new class_243(((double)random.method_43057() - 0.5) * 0.3, y, 0.6);
            postion = postion.method_1037(-entity.method_36455() * ((float)Math.PI / 180));
            postion = postion.method_1024(-entity.method_36454() * ((float)Math.PI / 180));
            postion = postion.method_1031(entity.method_23317(), entity.method_23320(), entity.method_23321());
            world.method_8406((class_2394)class_2398.field_11202, postion.field_1352, postion.field_1351, postion.field_1350, velocity.field_1352, velocity.field_1351 + 1.0, velocity.field_1350);
        }
    }
}

