/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.api.CollectWaterCallback;
import com.github.thedeathlycow.scorchful.block.NetherLilyBlock;
import com.github.thedeathlycow.scorchful.item.DrinkItem;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.SStats;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class WaterSkinItem
extends DrinkItem {
    public static final class_2583 TOOLTIP_STYLE = class_2583.field_24360.method_10977(class_124.field_1075);
    public static final class_2583 PARCHING_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    public static final int MAX_DRINKS = 16;
    public static final class_2561 FULL_ITEM_NAME = class_2561.method_43471((String)"item.scorchful.water_skin.filled");
    public static final class_2561 PARTIALLY_FULL_ITEM_NAME = class_2561.method_43471((String)"item.scorchful.water_skin.partially_filled");
    public static final class_2561 EMPTY_ITEM_NAME = class_2561.method_43471((String)"item.scorchful.water_skin.empty");

    public WaterSkinItem(class_1792.class_1793 settings) {
        super(settings);
        class_5620.field_27776.comp_1982().put(this, this::onCauldronInteract);
    }

    @Override
    protected class_1799 getPostConsumeStack(class_1799 stack, class_1937 world, class_3222 serverPlayer) {
        if (!serverPlayer.method_7337()) {
            WaterSkinItem.addDrinks(stack, -1);
        }
        return stack;
    }

    @Override
    public class_1799 method_7854() {
        class_1799 itemStack = super.method_7854();
        itemStack.method_57379(SDataComponentTypes.NUM_DRINKS, (Object)0);
        return itemStack;
    }

    public static int getNumDrinks(class_1799 stack) {
        return (Integer)stack.method_57825(SDataComponentTypes.NUM_DRINKS, (Object)0);
    }

    public static float getFill(class_1799 stack) {
        return (float)WaterSkinItem.getNumDrinks(stack) / 16.0f;
    }

    public static boolean hasDrink(class_1799 stack) {
        return WaterSkinItem.getNumDrinks(stack) > 0;
    }

    public static void addDrinks(class_1799 stack, int value) {
        stack.method_57368(SDataComponentTypes.NUM_DRINKS, (Object)0, currentDrinks -> class_3532.method_15340((int)(currentDrinks + value), (int)0, (int)16));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipType) {
        int numDrinks = WaterSkinItem.getNumDrinks(stack);
        if (numDrinks > 0) {
            super.method_7851(stack, context, tooltip, tooltipType);
        }
        class_5250 text = numDrinks > 0 ? class_2561.method_43469((String)"item.scorchful.water_skin.tooltip.count", (Object[])new Object[]{numDrinks, 16}) : class_2561.method_43471((String)"item.scorchful.water_skin.tooltip.empty");
        text.method_10862(TOOLTIP_STYLE);
        tooltip.add((class_2561)text);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        class_1269 refillResult = this.tryRefill(world, user, stack);
        if (refillResult != null) {
            return refillResult;
        }
        if (WaterSkinItem.hasDrink(stack)) {
            return super.method_7836(world, user, hand);
        }
        return class_1269.field_5811;
    }

    public class_2561 method_7864(class_1799 stack) {
        int numDrinks = WaterSkinItem.getNumDrinks(stack);
        return switch (numDrinks) {
            case 0 -> EMPTY_ITEM_NAME;
            case 16 -> FULL_ITEM_NAME;
            default -> PARTIALLY_FULL_ITEM_NAME;
        };
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!WaterSkinItem.hasDrink(stack)) {
            return stack;
        }
        return super.method_7861(stack, world, user);
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return WaterSkinItem.hasDrink(stack) ? 32 : 0;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return WaterSkinItem.hasDrink(stack) ? class_1839.field_8946 : class_1839.field_8952;
    }

    public boolean method_31567(class_1799 stack) {
        int numDrinks = WaterSkinItem.getNumDrinks(stack);
        return numDrinks < 16;
    }

    public int method_31569(class_1799 stack) {
        int numDrinks = WaterSkinItem.getNumDrinks(stack);
        if (numDrinks == 0) {
            return 0;
        }
        return Math.round((float)numDrinks / 16.0f * 13.0f);
    }

    public int method_31571(class_1799 stack) {
        float fill = Math.max(0.0f, WaterSkinItem.getFill(stack));
        float saturationValue = class_3532.method_37958((float)fill, (float)0.0f, (float)1.0f, (float)0.5f, (float)1.0f);
        return class_3532.method_15369((float)0.5833333f, (float)saturationValue, (float)saturationValue);
    }

    protected void fill(class_1799 stack, class_1657 player, class_1937 world, class_2338 sourcePos, int amount) {
        world.method_8396(null, player.method_24515(), SSoundEvents.ITEM_WATER_SKIN_FILL, class_3419.field_15248, 1.0f, 1.0f);
        world.method_33596((class_1297)player, (class_6880)class_5712.field_28167, sourcePos);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        WaterSkinItem.addDrinks(stack, amount);
        ((CollectWaterCallback)CollectWaterCallback.EVENT.invoker()).onWaterCollected(player, stack, sourcePos);
    }

    @Nullable
    private class_1269 tryRefill(class_1937 world, class_1657 user, class_1799 stack) {
        class_3965 blockHitResult = class_1792.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1345);
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 hitPos = blockHitResult.method_17777();
            if (!world.method_8505(user, hitPos) || WaterSkinItem.getNumDrinks(stack) >= 16) {
                return null;
            }
            if (world.method_8316(hitPos).method_15767(class_3486.field_15517)) {
                if (!world.field_9236) {
                    this.fill(stack, user, world, hitPos, 4);
                }
                return class_1269.field_5812;
            }
        }
        return null;
    }

    private class_1269 onCauldronInteract(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        if (!world.field_9236) {
            this.fill(stack, player, world, pos, 1);
            player.method_7281(class_3468.field_15373);
            class_5556.method_31650((class_2680)state, (class_1937)world, (class_2338)pos);
        }
        return class_1269.field_5812;
    }

    public class_1269 onWarpedLilyInteract(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        if (WaterSkinItem.getNumDrinks(stack) >= 16) {
            return class_1269.field_52423;
        }
        if ((Integer)state.method_11654((class_2769)NetherLilyBlock.WATER_SATURATION_LEVEL) < 3) {
            return class_1269.field_5814;
        }
        if (!world.field_9236) {
            this.fill(stack, player, world, pos, 4);
            player.method_7281(SStats.USE_WARPED_LILY);
            NetherLilyBlock.setWater(state, world, pos, 0);
        }
        return class_1269.field_5812;
    }
}

