/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.registry.tag.SBiomeTags;
import com.mojang.serialization.Codec;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3542;
import net.minecraft.class_6880;

public class Sandstorms {
    public static SandstormType getCurrentSandStorm(class_1937 world, class_2338 pos, boolean includeSurface) {
        if (!world.method_8419() || includeSurface && world.method_8520(pos)) {
            return SandstormType.NONE;
        }
        if (includeSurface && !world.method_8311(pos)) {
            return SandstormType.NONE;
        }
        if (includeSurface && world.method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return SandstormType.NONE;
        }
        class_6880 biome = world.method_23753(pos);
        if (Sandstorms.hasRegularSandStorms((class_6880<class_1959>)biome)) {
            return SandstormType.REGULAR;
        }
        if (Sandstorms.hasRedSandStorms((class_6880<class_1959>)biome)) {
            return SandstormType.RED;
        }
        return SandstormType.NONE;
    }

    public static SandstormType getCurrentSandStorm(class_1937 world, class_2338 pos) {
        return Sandstorms.getCurrentSandStorm(world, pos, true);
    }

    public static boolean isSandStorming(class_1937 world, class_2338 pos) {
        return Sandstorms.getCurrentSandStorm(world, pos, false) != SandstormType.NONE;
    }

    public static boolean hasSandStorms(class_6880<class_1959> biome) {
        return !((class_1959)biome.comp_349()).method_48163() && biome.method_40220(SBiomeTags.HAS_SAND_STORMS);
    }

    public static boolean hasRegularSandStorms(class_6880<class_1959> biome) {
        return !((class_1959)biome.comp_349()).method_48163() && biome.method_40220(SBiomeTags.HAS_REGULAR_SAND_STORMS);
    }

    public static boolean hasRedSandStorms(class_6880<class_1959> biome) {
        return !((class_1959)biome.comp_349()).method_48163() && biome.method_40220(SBiomeTags.HAS_RED_SAND_STORMS);
    }

    private Sandstorms() {
    }

    public static enum SandstormType implements class_3542
    {
        NONE("no_sandstorm"),
        REGULAR("regular_sandstorm"),
        RED("red_sandstorm");

        public static final Codec<SandstormType> CODEC;
        private final String id;

        private SandstormType(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        static {
            CODEC = class_3542.method_28140(SandstormType::values);
        }
    }
}

