/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.environment.provider;

import com.github.thedeathlycow.thermoo.api.environment.provider.EnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.TemperateSeasonEnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.environment.provider.TropicalSeasonEnvironmentProvider;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeason;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_6880;
import net.minecraft.class_9323;

public abstract sealed class SeasonalEnvironmentProvider
implements EnvironmentProvider
permits TemperateSeasonEnvironmentProvider, TropicalSeasonEnvironmentProvider {
    private final Optional<ThermooSeason> fallbackSeason;
    private final Map<ThermooSeason, class_6880<EnvironmentProvider>> seasons;

    protected SeasonalEnvironmentProvider(Optional<ThermooSeason> fallbackSeason, Map<ThermooSeason, class_6880<EnvironmentProvider>> seasons) {
        this.fallbackSeason = fallbackSeason;
        this.seasons = new EnumMap<ThermooSeason, class_6880<EnvironmentProvider>>(ThermooSeason.class);
        this.seasons.putAll(seasons);
    }

    @Override
    public final void buildCurrentComponents(class_1937 world, class_2338 pos, class_6880<class_1959> biome, class_9323.class_9324 builder) {
        class_6880<EnvironmentProvider> provider;
        Optional<ThermooSeason> season = this.getCurrentSeason(world, pos).or(this::fallbackSeason);
        if (season.isPresent() && (provider = this.seasons.get((Object)season.get())) != null) {
            ((EnvironmentProvider)provider.comp_349()).buildCurrentComponents(world, pos, biome, builder);
        }
    }

    public final Optional<ThermooSeason> fallbackSeason() {
        return this.fallbackSeason;
    }

    public final Map<ThermooSeason, class_6880<EnvironmentProvider>> seasons() {
        return Collections.unmodifiableMap(this.seasons);
    }

    protected abstract Optional<ThermooSeason> getCurrentSeason(class_1937 var1, class_2338 var2);

    protected static MapCodec<Map<ThermooSeason, class_6880<EnvironmentProvider>>> createSeasonMapCodec() {
        return Codec.simpleMap(ThermooSeason.CODEC, EnvironmentProvider.ENTRY_CODEC, (Keyable)class_3542.method_28142((class_3542[])ThermooSeason.values())).validate((T seasonMap) -> {
            if (seasonMap.isEmpty()) {
                return DataResult.error(() -> "No season key in: " + String.valueOf(seasonMap));
            }
            return DataResult.success((Object)seasonMap);
        });
    }

    protected static <T extends SeasonalEnvironmentProvider> MapCodec<T> validate(MapCodec<T> codec) {
        return codec.validate((T provider) -> {
            Optional<ThermooSeason> season = provider.fallbackSeason();
            if (season.isEmpty()) {
                return DataResult.success((Object)provider);
            }
            if (!provider.seasons().containsKey((Object)season.get())) {
                return DataResult.error(() -> "Fallback season '" + ((ThermooSeason)((Object)((Object)((Object)season.get())))).method_15434() + "' is not a key in: " + String.valueOf(provider.seasons()));
            }
            return DataResult.success((Object)provider);
        });
    }
}

