/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import com.github.thedeathlycow.scorchful.particle.DustGrainParticleEffect;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import com.github.thedeathlycow.scorchful.util.SMth;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_6854;
import net.minecraft.class_6880;
import net.minecraft.class_758;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SandstormEffects {
    public static final class_243 REGULAR_SANDSTORM_FOG_COLOR = class_243.method_24457((int)14264964);
    public static final Vector3f REGULAR_SANDSTORM_PARTICLE_COLOR = class_243.method_24457((int)14264964).method_46409();
    private static final float START_FOG_SPHERE_RAIN_GRADIENT = 0.75f;
    private static final float PARTICLE_SCALE = 10.0f;

    public static boolean shouldCancelClouds(class_638 world, class_2338 pos) {
        return world.method_8430(1.0f) > 0.75f && Sandstorms.isSandStorming((class_1937)world, pos);
    }

    public static void tickSandstormParticles(class_638 clientWorld) {
        if (!clientWorld.method_8419() || clientWorld.method_54719().method_54754()) {
            return;
        }
        ClientConfig config = Scorchful.getConfig().clientConfig;
        int renderDistance = config.getSandStormParticleRenderDistance();
        if (!config.isSandstormParticlesEnabled() || renderDistance <= 0) {
            return;
        }
        class_310 gameClient = class_310.method_1551();
        class_4184 camera = gameClient.field_1773.method_19418();
        if (camera == null) {
            return;
        }
        class_2338 cameraPos = camera.method_19328();
        class_2338.class_2339 pos = new class_2338.class_2339();
        DustGrainParticleEffect particle = new DustGrainParticleEffect(REGULAR_SANDSTORM_PARTICLE_COLOR, 10.0f);
        int rarity = config.getSandStormParticleRarity();
        int cameraY = cameraPos.method_10264();
        float particleVelocity = config.getSandStormParticleVelocity();
        for (int x = cameraPos.method_10263() - renderDistance; x < cameraPos.method_10263() + renderDistance; ++x) {
            for (int z = cameraPos.method_10260() - renderDistance; z < cameraPos.method_10260() + renderDistance; ++z) {
                int y = cameraY + clientWorld.field_9229.method_39332(-renderDistance / 2, (renderDistance + 1) / 2);
                y = Math.max(y, clientWorld.method_8624(class_2902.class_2903.field_13197, x, z));
                pos.method_10103(x, y, z);
                SandstormEffects.addParticle(clientWorld, (class_2394)particle, (class_2338)pos, rarity, particleVelocity);
            }
        }
    }

    public static Optional<class_243> getFogColor(class_638 world, class_4184 camera, float baseRed, float baseGreen, float baseBlue, float tickDelta) {
        ClientConfig config = Scorchful.getConfig().clientConfig;
        if (!config.isSandstormFogEnabled()) {
            return Optional.empty();
        }
        float gradient = world.method_8430(1.0f);
        if (gradient > 0.0f && Sandstorms.isSandStorming((class_1937)world, camera.method_19328())) {
            class_243 normalColor = new class_243((double)baseRed, (double)baseGreen, (double)baseBlue);
            class_243 adjustedColor = SMth.lerp(gradient, normalColor, REGULAR_SANDSTORM_FOG_COLOR);
            float skyAngle = class_3532.method_15363((float)(class_3532.method_15362((float)(world.method_30274(tickDelta) * 2.0f * (float)Math.PI)) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            class_243 sandStormColor = adjustedColor;
            class_2338.class_2339 samplePos = new class_2338.class_2339();
            adjustedColor = class_6491.method_24895((class_243)camera.method_19326(), (x, y, z) -> {
                samplePos.method_10103(x, y, z);
                class_6880 biome = world.method_23753((class_2338)samplePos);
                return world.method_28103().method_28112(Sandstorms.hasSandStorms((class_6880<class_1959>)biome) ? sandStormColor : normalColor, skyAngle);
            });
            return Optional.of(adjustedColor);
        }
        return Optional.empty();
    }

    public static void updateFogDistance(class_4184 camera, float viewDistance, class_5636 cameraSubmersionType, class_758.class_7285 fogData) {
        class_2338 pos;
        ClientConfig config = Scorchful.getConfig().clientConfig;
        if (!config.isSandstormFogEnabled()) {
            return;
        }
        class_1297 focused = camera.method_19331();
        class_1937 world = focused.method_37908();
        float rainGradient = world.method_8430(1.0f);
        if (cameraSubmersionType == class_5636.field_27888 && rainGradient > 0.0f && Sandstorms.isSandStorming(world, pos = camera.method_19328())) {
            class_2338.class_2339 samplePos = new class_2338.class_2339();
            class_243 baseRadius = new class_243((double)fogData.field_38340, (double)fogData.field_38341, 0.0);
            class_243 fogRadius = new class_243((double)config.getSandStormFogStart(), (double)config.getSandStormFogEnd(), 0.0);
            class_243 fogDistances = class_6491.method_24895((class_243)camera.method_19326(), (x, y, z) -> {
                samplePos.method_10103(x, y, z);
                if (Sandstorms.hasSandStorms((class_6880<class_1959>)world.method_23753((class_2338)samplePos))) {
                    return fogRadius;
                }
                return baseRadius;
            });
            SandstormEffects.updateFogRadius(fogData, fogDistances, rainGradient);
        }
    }

    private static void updateFogRadius(class_758.class_7285 fogData, class_243 fogDistances, float rainGradient) {
        fogData.field_38340 = class_3532.method_16439((float)rainGradient, (float)fogData.field_38340, (float)((float)fogDistances.field_1352));
        fogData.field_38341 = class_3532.method_16439((float)rainGradient, (float)fogData.field_38341, (float)((float)fogDistances.field_1351));
        if (rainGradient > 0.75f) {
            fogData.field_38342 = class_6854.field_36350;
        }
    }

    private static void addParticle(class_638 world, class_2394 particle, class_2338 pos, int rarity, float velocity) {
        if (Sandstorms.getCurrentSandStorm((class_1937)world, pos) != Sandstorms.SandstormType.NONE && world.field_9229.method_43048(rarity) == 0) {
            world.method_8406(particle, (double)pos.method_10263() + world.field_9229.method_43058(), (double)pos.method_10264() + world.field_9229.method_43058(), (double)pos.method_10260() + world.field_9229.method_43058(), (double)velocity, 0.0, 0.0);
        }
    }

    private SandstormEffects() {
    }
}

