/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal.RascalFindInteractionTargetTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal.RascalWaitForPlayerTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public final class RascalBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super RascalEntity>>> SENSORS;
    public static final int NOD_COOLDOWN = 10;
    private static final UniformInt NOD_COOLDOWN_PROVIDER;
    private static final UniformInt AVOID_MEMORY_DURATION;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        RascalBrain.addCoreActivities((Brain<RascalEntity>)brain);
        RascalBrain.addIdleActivities((Brain<RascalEntity>)brain);
        RascalBrain.addWaitActivities((Brain<RascalEntity>)brain);
        RascalBrain.addAvoidActivities((Brain<RascalEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<RascalEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get())));
    }

    private static void addIdleActivities(Brain<RascalEntity> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, RascalFindInteractionTargetTask.create(6)), (Object)Pair.of((Object)0, RascalBrain.makeRandomWanderTask())));
    }

    private static void addWaitActivities(Brain<RascalEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped((Activity)FriendsAndFoesActivities.RASCAL_WAIT.get(), 10, ImmutableList.of((Object)((Object)new RascalWaitForPlayerTask())), MemoryModuleType.INTERACTION_TARGET);
    }

    private static void addAvoidActivities(Brain<RascalEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.0f, (int)32, (boolean)true)), MemoryModuleType.AVOID_TARGET);
    }

    public static void updateActivities(RascalEntity rascal) {
        rascal.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)FriendsAndFoesActivities.RASCAL_WAIT.get()), (Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    private static RunOne<RascalEntity> makeRandomWanderTask() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void setNodCooldown(RascalEntity rascal) {
        rascal.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get(), (Object)NOD_COOLDOWN_PROVIDER.sample(rascal.getRandom()));
        RascalBrain.onCooldown(rascal);
    }

    public static boolean shouldRunAway(RascalEntity rascal) {
        return rascal.getBrain().getMemoryInternal((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get()).isPresent();
    }

    public static void onCooldown(RascalEntity rascal) {
        if (!RascalBrain.shouldRunAway(rascal)) {
            return;
        }
        if (rascal.hasCustomName()) {
            return;
        }
        LivingEntity nearestTarget = rascal.getBrain().getMemoryInternal(MemoryModuleType.INTERACTION_TARGET).orElse(null);
        if (nearestTarget == null) {
            return;
        }
        RascalBrain.runAwayFrom(rascal, nearestTarget);
    }

    private static void runAwayFrom(RascalEntity rascal, LivingEntity target) {
        rascal.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        rascal.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        rascal.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        rascal.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)AVOID_MEMORY_DURATION.sample(rascal.getRandom()));
    }

    static {
        SENSORS = List.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS);
        MEMORY_MODULES = List.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.AVOID_TARGET, MemoryModuleType.INTERACTION_TARGET, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get());
        NOD_COOLDOWN_PROVIDER = TimeUtil.rangeOfSeconds((int)10, (int)10);
        AVOID_MEMORY_DURATION = TimeUtil.rangeOfSeconds((int)10, (int)10);
    }
}

