/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.IceologerIceChunkModel;
import com.faboslav.friendsandfoes.common.client.render.entity.state.IceologerIceChunkRenderState;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class IceologerIceChunkRenderer
extends EntityRenderer<IceologerIceChunkEntity, IceologerIceChunkRenderState> {
    private static final ResourceLocation TEXTURE = FriendsAndFoes.makeID("textures/entity/illager/ice_chunk.png");
    private final IceologerIceChunkModel model;

    public IceologerIceChunkRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new IceologerIceChunkModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.ICEOLOGER_ICE_CHUNK_LAYER));
    }

    public void render(IceologerIceChunkRenderState renderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        IceologerIceChunkEntity iceChunk = renderState.iceologerIceChunk;
        float animationProgress = iceChunk.getSummonAnimationProgress();
        if (animationProgress == 0.0f) {
            return;
        }
        float summonAnimationProgress = Mth.lerp((float)renderState.ageInTicks, (float)iceChunk.getLastSummonAnimationProgress(), (float)iceChunk.getSummonAnimationProgress());
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f - iceChunk.getYRot()));
        this.model.setupAnim(renderState);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.model.renderType(TEXTURE));
        poseStack.scale(summonAnimationProgress, summonAnimationProgress, summonAnimationProgress);
        this.model.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((EntityRenderState)renderState, poseStack, multiBufferSource, i);
    }

    public IceologerIceChunkRenderState createRenderState() {
        return new IceologerIceChunkRenderState();
    }

    public void extractRenderState(IceologerIceChunkEntity iceologerIceChunk, IceologerIceChunkRenderState renderState, float partialTick) {
        super.extractRenderState((Entity)iceologerIceChunk, (EntityRenderState)renderState, partialTick);
        renderState.iceologerIceChunk = iceologerIceChunk;
    }
}

