/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.util;

import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedMobEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public final class TotemUtil {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int NEGATIVE_EFFECT_TICKS = 400;
    public static final int POSITIVE_EFFECT_TICKS = 200;
    private static final class_4051 FREEZE_TARGET_PREDICATE = class_4051.method_36626().method_18424().method_36627().method_18420((livingEntity, serverLevel) -> !(livingEntity instanceof class_1657) || !((class_1657)livingEntity).method_68878());
    private static final class_4051 ATTACK_TARGET_PREDICATE = class_4051.method_36626().method_18424().method_36627();

    public static void playActivateAnimation(class_1799 itemStack, class_1297 entity, class_2396<?> particleType) {
        class_310 minecraftClient = class_310.method_1551();
        minecraftClient.field_1713.method_3051(entity, (class_2394)particleType, 30);
        class_638 clientWorld = minecraftClient.field_1687;
        if (clientWorld != null) {
            clientWorld.method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14931, entity.method_5634(), 1.0f, 1.0f, false);
        }
        if (entity == minecraftClient.field_1724) {
            minecraftClient.field_1773.method_3189(itemStack);
        }
    }

    public static void freezeEntities(class_1657 player, class_3218 level) {
        List nearbyEntities = level.method_8390(class_1309.class, player.method_5829().method_1014(9.0), livingEntity -> FREEZE_TARGET_PREDICATE.method_18419(level, (class_1309)player, livingEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            nearbyEntity.method_32317(400);
            nearbyEntity.method_6092(new class_1293(VersionedMobEffects.MOVEMENT_SLOWNESS, 400, 1));
        });
    }

    public static void createIllusions(class_1657 player, class_3218 level) {
        player.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), 1.0f, player.method_6017());
        class_243 illusionerPosition = player.method_19538();
        float slice = 0.69813174f;
        int radius = 9;
        ArrayList<PlayerIllusionEntity> createdPlayerIllusions = new ArrayList<PlayerIllusionEntity>();
        for (int point = 0; point < 9; ++point) {
            int z;
            int y;
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.method_10216() + (double)((float)radius * class_3532.method_15362((float)angle)));
            PlayerIllusionEntity createdPlayerIllusion = TotemUtil.createIllusion(player, level, x, y = (int)illusionerPosition.method_10214(), z = (int)(illusionerPosition.method_10215() + (double)((float)radius * class_3532.method_15374((float)angle))));
            if (createdPlayerIllusion == null) continue;
            createdPlayerIllusions.add(createdPlayerIllusion);
        }
        List nearbyEntities = level.method_8390(class_1308.class, player.method_5829().method_1014(18.0), mobEntity -> ATTACK_TARGET_PREDICATE.method_18419(level, (class_1309)player, (class_1309)mobEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            if (nearbyEntity.method_5968() == player) {
                if (!createdPlayerIllusions.isEmpty()) {
                    nearbyEntity.method_19540(true);
                    nearbyEntity.method_6015((class_1309)createdPlayerIllusions.get(player.method_59922().method_43048(createdPlayerIllusions.size())));
                    nearbyEntity.method_6114((class_1297)createdPlayerIllusions.get(player.method_59922().method_43048(createdPlayerIllusions.size())));
                }
                nearbyEntity.method_6092(new class_1293(class_1294.field_5919, 400, 1));
            }
        });
        if (!createdPlayerIllusions.isEmpty()) {
            class_1309 attacker;
            PlayerIllusionEntity illusionToReplace = (PlayerIllusionEntity)((Object)createdPlayerIllusions.get(player.method_59922().method_43048(createdPlayerIllusions.size())));
            boolean teleportResult = TotemUtil.tryToTeleport(player, level, illusionToReplace.method_31477(), illusionToReplace.method_31478(), illusionToReplace.method_31479());
            if (teleportResult) {
                TotemUtil.spawnCloudParticles(player, level);
            }
            if ((attacker = illusionToReplace.method_6065()) != null) {
                illusionToReplace.method_6015(null);
                illusionToReplace.method_6114(null);
            }
            illusionToReplace.method_31472();
        }
        player.method_6092(new class_1293(class_1294.field_5905, 200));
    }

    @Nullable
    private static PlayerIllusionEntity createIllusion(class_1657 player, class_3218 serverLevel, int x, int y, int z) {
        float randomYaw;
        PlayerIllusionEntity playerIllusion = (PlayerIllusionEntity)((class_1299)FriendsAndFoesEntityTypes.PLAYER_ILLUSION.get()).method_5883((class_1937)serverLevel, VersionedEntitySpawnReason.MOB_SUMMONED);
        if (playerIllusion == null) {
            return null;
        }
        playerIllusion.prevCapeX = player.field_7524;
        playerIllusion.prevCapeY = player.field_7502;
        playerIllusion.prevCapeZ = player.field_7522;
        playerIllusion.capeX = player.field_7500;
        playerIllusion.capeY = player.field_7521;
        playerIllusion.capeZ = player.field_7499;
        playerIllusion.prevStrideDistance = player.field_7505;
        playerIllusion.strideDistance = player.field_7483;
        playerIllusion.method_5673(class_1304.field_6173, player.method_6047().method_7972());
        playerIllusion.method_5673(class_1304.field_6171, player.method_6079().method_7972());
        for (class_1304 slot : class_1304.values()) {
            class_1799 item = player.method_6118(slot);
            if (item.method_7960()) continue;
            playerIllusion.method_24523(serverLevel, item.method_7972());
        }
        playerIllusion.method_6033(player.method_6063());
        playerIllusion.method_5719((class_1297)player);
        playerIllusion.field_5982 = randomYaw = 360.0f * player.method_59922().method_43057();
        playerIllusion.method_36456(randomYaw);
        playerIllusion.field_6220 = randomYaw;
        playerIllusion.method_5636(randomYaw);
        playerIllusion.field_6259 = randomYaw;
        playerIllusion.method_5847(randomYaw);
        playerIllusion.setPlayerUuid(player.method_5667());
        playerIllusion.setPlayer(player);
        playerIllusion.setTicksUntilDespawn(600);
        boolean teleportResult = playerIllusion.tryToTeleport(x, y, z);
        if (teleportResult) {
            serverLevel.method_8649((class_1297)playerIllusion);
            playerIllusion.spawnCloudParticles();
        }
        return playerIllusion;
    }

    private static boolean tryToTeleport(class_1657 player, class_3218 level, int x, int y, int z) {
        int worldBottomY = level.method_31607();
        double bottomY = Math.max(y -= 8, worldBottomY);
        double topY = Math.min(bottomY + 16.0, (double)(level.method_32819() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = player.method_6082((double)x, (double)(y = (int)class_3532.method_15350((double)(y + 1), (double)bottomY, (double)topY)), (double)z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private static void spawnCloudParticles(class_1657 player, class_3218 level) {
        TotemUtil.spawnParticles(player, level, class_2398.field_11204, 16);
    }

    private static void spawnParticles(class_1657 player, class_3218 level, class_2400 particleType, int amount) {
        for (int i = 0; i < amount; ++i) {
            level.method_65096((class_2394)particleType, player.method_23322(0.5), player.method_23319() + 0.5, player.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

