/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.WildfireAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.pose.WildfireEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import com.faboslav.friendsandfoes.common.versions.VersionedProfilerProvider;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public final class WildfireEntity
extends class_1588
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private float damageAmountCounter = 0.0f;
    public static final float GENERIC_ATTACK_DAMAGE = 8.0f;
    public static final float GENERIC_FOLLOW_RANGE = 32.0f;
    public static final int DEFAULT_ACTIVE_SHIELDS_COUNT = 4;
    public static final int DEFAULT_TICKS_UNTIL_SHIELD_REGENERATION = 300;
    public static final int DEFAULT_SUMMONED_BLAZES_COUNT = 0;
    public static final int MAXIMUM_SUMMONED_BLAZES_COUNT = 2;
    private static final String ACTIVE_SHIELDS_NBT_NAME = "ActiveShieldsCount";
    private static final String TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME = "TicksUntilShieldRegeneration";
    private static final String SUMMONED_BLAZES_COUNT_NBT_NAME = "SummonedBlazesCount";
    private static final class_2940<Integer> ACTIVE_SHIELDS_COUNT = class_2945.method_12791(WildfireEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TICKS_UNTIL_SHIELD_REGENERATION = class_2945.method_12791(WildfireEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SUMMONED_BLAZES_COUNT = class_2945.method_12791(WildfireEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> POSE_TICKS = class_2945.method_12791(WildfireEntity.class, (class_2941)class_2943.field_13327);

    public WildfireEntity(class_1299<? extends WildfireEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, 8.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.field_6194 = 10;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setPose(WildfireEntityPose.IDLE);
        this.setActiveShieldsCount(4);
        this.setSummonedBlazesCount(0);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (AnimationHolder animation : this.getTrackedAnimations()) {
                this.animationContextTracker.add(animation);
            }
            this.animationContextTracker.add(WildfireAnimations.SHIELD_ROTATION);
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return WildfireAnimations.TRACKED_ANIMATIONS;
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        return WildfireAnimations.WALK;
    }

    @Override
    public int getCurrentAnimationTick() {
        return (Integer)this.field_6011.method_12789(POSE_TICKS);
    }

    @Override
    public void setCurrentAnimationTick(int keyframeAnimationTicks) {
        this.field_6011.method_12778(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return WildfireBrain.create(dynamic);
    }

    public class_4095<WildfireEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = VersionedProfilerProvider.getProfiler((class_1297)this);
        profiler.method_15396("wildfireBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("wildfireActivityUpdate");
        WildfireBrain.updateActivities(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    public static class_5132.class_5133 createWildfireAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23722, 32.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ACTIVE_SHIELDS_COUNT, (Object)4);
        builder.method_56912(TICKS_UNTIL_SHIELD_REGENERATION, (Object)300);
        builder.method_56912(SUMMONED_BLAZES_COUNT, (Object)0);
        builder.method_56912(POSE_TICKS, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(ACTIVE_SHIELDS_NBT_NAME, this.getActiveShieldsCount());
        nbt.method_10569(TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME, this.getTicksUntilShieldRegeneration());
        nbt.method_10569(SUMMONED_BLAZES_COUNT_NBT_NAME, this.getSummonedBlazesCount());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setActiveShieldsCount(VersionedNbt.getInt(nbt, ACTIVE_SHIELDS_NBT_NAME, 4));
        this.setTicksUntilShieldRegeneration(VersionedNbt.getInt(nbt, TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME, 300));
        this.setSummonedBlazesCount(VersionedNbt.getInt(nbt, SUMMONED_BLAZES_COUNT_NBT_NAME, 0));
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (state.method_51176()) {
            return;
        }
        class_2680 blockState = this.method_37908().method_8320(pos.method_10084());
        class_2498 blockSoundGroup = blockState.method_26164(class_3481.field_28040) ? blockState.method_26231() : state.method_26231();
        this.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_STEP.get(), blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599());
    }

    public class_3414 getShootSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHOOT.get();
    }

    public void playShootSound() {
        this.method_5783(this.getShootSound(), this.method_6107(), this.method_6017());
    }

    public class_3414 getShockwaveSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHOCKWAVE.get();
    }

    public void playShockwaveSound() {
        this.method_5783(this.getShockwaveSound(), this.method_6107(), this.method_6017());
    }

    public void breakShield() {
        this.setActiveShieldsCount(this.getActiveShieldsCount() - 1);
    }

    public void regenerateShield() {
        if (this.getActiveShieldsCount() >= 4) {
            return;
        }
        this.setActiveShieldsCount(this.getActiveShieldsCount() + 1);
    }

    public int getActiveShieldsCount() {
        return (Integer)this.field_6011.method_12789(ACTIVE_SHIELDS_COUNT);
    }

    public void setActiveShieldsCount(int activeShields) {
        this.field_6011.method_12778(ACTIVE_SHIELDS_COUNT, (Object)activeShields);
    }

    public boolean hasActiveShields() {
        return this.getActiveShieldsCount() > 0;
    }

    public int getTicksUntilShieldRegeneration() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_SHIELD_REGENERATION);
    }

    public void setTicksUntilShieldRegeneration(int ticksUntilShieldRegeneration) {
        this.field_6011.method_12778(TICKS_UNTIL_SHIELD_REGENERATION, (Object)ticksUntilShieldRegeneration);
    }

    public void resetTicksUntilShieldRegeneration() {
        this.setTicksUntilShieldRegeneration(300);
    }

    public int getSummonedBlazesCount() {
        return (Integer)this.field_6011.method_12789(SUMMONED_BLAZES_COUNT);
    }

    public void setSummonedBlazesCount(int summonedBlazesCount) {
        this.field_6011.method_12778(SUMMONED_BLAZES_COUNT, (Object)summonedBlazesCount);
    }

    public boolean areBlazesSummoned() {
        return this.getSummonedBlazesCount() > 0;
    }

    public class_3414 getShieldBreakSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHIELD_BREAK.get();
    }

    public void playShieldBreakSound() {
        this.method_5783(this.getShieldBreakSound(), this.method_6107(), this.method_6017());
    }

    protected class_3414 method_5994() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_DEATH.get();
    }

    public class_3414 getSummonBlazeSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SUMMON_BLAZE.get();
    }

    public void playSummonBlazeSound() {
        this.method_5783(this.getSummonBlazeSound(), this.method_6107(), this.method_6017());
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableWildfire) {
            this.method_31472();
        }
        if (this.field_42108.method_48571()) {
            this.emitGroundParticles(20);
        } else {
            this.emitGroundParticles(1 + this.method_59922().method_43048(1));
        }
        super.method_5773();
        this.updateKeyframeAnimations();
        this.setTicksUntilShieldRegeneration(this.getTicksUntilShieldRegeneration() - 1);
        if (this.getTicksUntilShieldRegeneration() == 0) {
            this.regenerateShield();
            this.resetTicksUntilShieldRegeneration();
        }
    }

    protected void method_48565(float partialTick) {
        float f = this.getAnimationContextTracker().get(WildfireAnimations.SHOCKWAVE).isRunning() ? 0.0f : Math.min(partialTick * 4.0f, 1.0f);
        this.field_42108.method_48568(f, 0.4f, 1.0f);
    }

    private void updateKeyframeAnimations() {
        AnimationHolder animationToStart;
        if (!this.method_37908().method_8608()) {
            this.updateCurrentAnimationTick();
        }
        if ((animationToStart = this.getAnimationByPose()) != null) {
            this.tryToStartAnimation(animationToStart);
        }
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        AnimationHolder animation = null;
        if (this.isInPose(WildfireEntityPose.IDLE) && !this.field_42108.method_48571()) {
            animation = WildfireAnimations.IDLE;
        } else if (this.isInPose(WildfireEntityPose.SHOCKWAVE)) {
            animation = WildfireAnimations.SHOCKWAVE;
        }
        return animation;
    }

    private void tryToStartAnimation(AnimationHolder animationToStart) {
        if (this.isKeyframeAnimationRunning(animationToStart)) {
            return;
        }
        if (!this.method_37908().method_8608()) {
            this.setCurrentAnimationTick(animationToStart.get().lengthInTicks());
        }
        this.startKeyframeAnimation(animationToStart);
    }

    private void startKeyframeAnimation(AnimationHolder animationToStart) {
        for (AnimationHolder animation : this.getTrackedAnimations()) {
            if (animation == animationToStart) continue;
            this.stopKeyframeAnimation(animation);
        }
        this.startKeyframeAnimation(animationToStart, this.field_6012);
    }

    public void startShockwaveAnimation() {
        if (this.isInPose(WildfireEntityPose.SHOCKWAVE)) {
            return;
        }
        this.method_32876((class_6880)class_5712.field_45148);
        this.playShockwaveSound();
        this.setPose(WildfireEntityPose.SHOCKWAVE);
    }

    public void method_18380(class_4050 pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        super.method_18380(pose);
    }

    public void setPose(WildfireEntityPose pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        super.method_18380(pose.get());
    }

    public boolean isInPose(WildfireEntityPose pose) {
        return this.method_18376() == pose.get();
    }

    public void method_6007() {
        if (!this.method_24828() && this.method_18798().field_1351 < 0.0) {
            this.method_18799(this.method_18798().method_18805(1.0, (double)0.6f, 1.0));
        }
        if (this.method_37908().method_8608()) {
            if (this.method_59922().method_43048(24) != 0 || !this.method_5701()) {
                // empty if block
            }
            for (int i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.method_6007();
    }

    public void emitGroundParticles(int i) {
        if (!this.method_5765()) {
            class_2680 blockState;
            class_243 vec3 = this.method_5829().method_1005();
            class_243 vec32 = new class_243(vec3.field_1352, this.method_19538().field_1351, vec3.field_1350);
            class_2680 class_26802 = blockState = !this.method_55667().method_26215() ? this.method_55667() : this.method_25936();
            if (blockState.method_26217() != class_2464.field_11455) {
                for (int j = 0; j < i; ++j) {
                    this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), vec32.field_1352, vec32.field_1351, vec32.field_1350, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        if (damageSource == this.method_48923().method_48830() || damageSource == this.method_48923().method_51847()) {
            return super.method_64397(level, damageSource, amount);
        }
        class_1297 attacker = damageSource.method_5529();
        if (damageSource == this.method_48923().method_48794() || attacker != null && attacker.method_5864().method_20210(FriendsAndFoesTags.WILDFIRE_ALLIES)) {
            return false;
        }
        if (this.hasActiveShields()) {
            this.damageAmountCounter += amount;
            float shieldBreakDamageThreshold = (float)this.method_45325(class_5134.field_23716) * 0.25f;
            if (this.damageAmountCounter >= shieldBreakDamageThreshold) {
                if (attacker instanceof class_1309) {
                    VersionedEntity.hurt(attacker, this.method_48923().method_48812((class_1309)this), 8.0f);
                }
                this.breakShield();
                this.playShieldBreakSound();
                this.damageAmountCounter = 0.0f;
            }
            amount = 0.0f;
        }
        this.resetTicksUntilShieldRegeneration();
        boolean damageResult = super.method_64397(level, damageSource, amount);
        if (damageResult && attacker instanceof class_1309) {
            WildfireBrain.onAttacked(this, (class_1309)attacker);
        }
        return damageResult;
    }

    public float method_5718() {
        return 1.0f;
    }

    public boolean method_29503() {
        return true;
    }

    public boolean method_5809() {
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }
}

