/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network.packet;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationLoader;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationParser;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.network.MessageHandler;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public record EntityAnimationsSyncPacket(Map<class_2960, AnimationDefinition> entityAnimations) implements Packet<EntityAnimationsSyncPacket>
{
    public static final class_2960 ID = FriendsAndFoes.makeID("entity_animations_sync_packet");
    public static final ClientboundPacketType<EntityAnimationsSyncPacket> TYPE = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        Map<class_2960, AnimationDefinition> entityAnimations = AnimationLoader.INSTANCE.getAnimations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AnimationHolder)entry.getValue()).get()));
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new EntityAnimationsSyncPacket(entityAnimations), event.player());
    }

    public PacketType<EntityAnimationsSyncPacket> type() {
        return TYPE;
    }

    public static class Handler
    implements ClientboundPacketType<EntityAnimationsSyncPacket> {
        public class_2960 id() {
            return ID;
        }

        public Runnable handle(EntityAnimationsSyncPacket packet) {
            return () -> AnimationLoader.INSTANCE.apply(packet.entityAnimations());
        }

        public EntityAnimationsSyncPacket decode(class_9129 buf) {
            HashMap<class_2960, AnimationDefinition> parsedEntityAnimations = new HashMap<class_2960, AnimationDefinition>();
            class_2487 data = buf.method_10798();
            if (data == null) {
                FriendsAndFoes.getLogger().error("Entity Animation packet is empty");
                return new EntityAnimationsSyncPacket(parsedEntityAnimations);
            }
            class_2499 entityAnimations = data.method_68569("entity_animations");
            for (int i = 0; i < entityAnimations.size(); ++i) {
                class_2487 entityAnimation = entityAnimations.method_68582(i);
                class_2520 resourceLocationTag = entityAnimation.method_10580("resource_location");
                class_2520 animationDefinitionTag = entityAnimation.method_10580("animation_definition");
                if (resourceLocationTag == null || animationDefinitionTag == null) {
                    FriendsAndFoes.getLogger().error("Entity Animation packet is invalid");
                    continue;
                }
                DataResult parsedResourceLocation = class_2960.field_25139.parse((DynamicOps)class_2509.field_11560, (Object)resourceLocationTag);
                parsedResourceLocation.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Resource Location packet entry: {}", (Object)error.message()));
                DataResult parsedAnimationDefinition = AnimationParser.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)animationDefinitionTag);
                parsedAnimationDefinition.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Animation Definition packet entry: {}", (Object)error.message()));
                parsedResourceLocation.result().ifPresent(validResourceLocation -> parsedAnimationDefinition.result().ifPresent(validAnimationDefinition -> parsedEntityAnimations.put((class_2960)validResourceLocation, (AnimationDefinition)validAnimationDefinition)));
            }
            return new EntityAnimationsSyncPacket(parsedEntityAnimations);
        }

        public void encode(EntityAnimationsSyncPacket packet, class_9129 buf) {
            class_2487 data = new class_2487();
            class_2499 entityAnimationsList = new class_2499();
            for (Map.Entry<class_2960, AnimationDefinition> entry : packet.entityAnimations().entrySet()) {
                class_2487 animationEntry = new class_2487();
                animationEntry.method_10582("resource_location", entry.getKey().toString());
                DataResult encodedDefinition = AnimationParser.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)entry.getValue());
                encodedDefinition.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to encode Animation Definition for {}: {}", entry.getKey(), (Object)error.message()));
                encodedDefinition.result().ifPresent(tag -> animationEntry.method_10566("animation_definition", tag));
                entityAnimationsList.add((Object)animationEntry);
            }
            data.method_10566("entity_animations", (class_2520)entityAnimationsList);
            buf.method_10794((class_2520)data);
        }
    }
}

