/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.feature;

import com.faboslav.friendsandfoes.common.client.render.entity.model.PlayerIllusionEntityModel;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.util.PlayerSkinProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class PlayerIllusionCapeLayer
extends RenderLayer<PlayerIllusionEntity, PlayerIllusionEntityModel<PlayerIllusionEntity>> {
    public PlayerIllusionCapeLayer(RenderLayerParent<PlayerIllusionEntity, PlayerIllusionEntityModel<PlayerIllusionEntity>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, PlayerIllusionEntity playerIllusion, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemStack;
        PlayerSkin playerSkin;
        if (!playerIllusion.isInvisible() && playerIllusion.isPartVisible(PlayerModelPart.CAPE) && (playerSkin = PlayerSkinProvider.getSkinTextures(playerIllusion)).capeTexture() != null && !(itemStack = playerIllusion.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA)) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.125f);
            double d = Mth.lerp((double)partialTicks, (double)playerIllusion.prevCapeX, (double)playerIllusion.capeX) - Mth.lerp((double)partialTicks, (double)playerIllusion.xo, (double)playerIllusion.getX());
            double e = Mth.lerp((double)partialTicks, (double)playerIllusion.prevCapeY, (double)playerIllusion.capeY) - Mth.lerp((double)partialTicks, (double)playerIllusion.yo, (double)playerIllusion.getY());
            double f = Mth.lerp((double)partialTicks, (double)playerIllusion.prevCapeZ, (double)playerIllusion.capeZ) - Mth.lerp((double)partialTicks, (double)playerIllusion.zo, (double)playerIllusion.getZ());
            float g = Mth.rotLerp((float)partialTicks, (float)playerIllusion.yBodyRotO, (float)playerIllusion.yBodyRot);
            double h = Mth.sin((float)(g * ((float)Math.PI / 180)));
            double i = -Mth.cos((float)(g * ((float)Math.PI / 180)));
            float j = (float)e * 10.0f;
            j = Mth.clamp((float)j, (float)-6.0f, (float)32.0f);
            float k = (float)(d * h + f * i) * 100.0f;
            k = Mth.clamp((float)k, (float)0.0f, (float)150.0f);
            float l = (float)(d * i - f * h) * 100.0f;
            l = Mth.clamp((float)l, (float)-20.0f, (float)20.0f);
            if (k < 0.0f) {
                k = 0.0f;
            }
            float m = Mth.lerp((float)partialTicks, (float)playerIllusion.prevStrideDistance, (float)playerIllusion.strideDistance);
            j += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)playerIllusion.walkDistO, (float)playerIllusion.walkDist) * 6.0f)) * 32.0f * m;
            if (playerIllusion.isCrouching()) {
                j += 25.0f;
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(6.0f + k / 2.0f + j));
            poseStack.mulPose(Axis.ZP.rotationDegrees(l / 2.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - l / 2.0f));
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)playerSkin.capeTexture()));
            ((PlayerIllusionEntityModel)this.getParentModel()).renderCloak(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

