/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.IceologerIceChunkModel;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public final class IceologerIceChunkRenderer
extends EntityRenderer<IceologerIceChunkEntity> {
    private static final ResourceLocation TEXTURE = FriendsAndFoes.makeID("textures/entity/illager/ice_chunk.png");
    private final IceologerIceChunkModel<IceologerIceChunkEntity> model;

    public IceologerIceChunkRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new IceologerIceChunkModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.ICEOLOGER_ICE_CHUNK_LAYER));
    }

    public void render(IceologerIceChunkEntity iceChunk, float f, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        float ageInTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        float animationProgress = iceChunk.getSummonAnimationProgress();
        if (animationProgress == 0.0f) {
            return;
        }
        float summonAnimationProgress = Mth.lerp((float)ageInTicks, (float)iceChunk.getLastSummonAnimationProgress(), (float)iceChunk.getSummonAnimationProgress());
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f - iceChunk.getYRot()));
        this.model.setupAnim(iceChunk, 0.0f, 0.0f, 0.0f, iceChunk.getYRot(), iceChunk.getXRot());
        poseStack.scale(summonAnimationProgress, summonAnimationProgress, summonAnimationProgress);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(this.model.renderType(TEXTURE));
        this.model.setupAnim(iceChunk, 0.0f, 0.0f, 0.0f, iceChunk.getYRot(), iceChunk.getXRot());
        this.model.prepareMobModel(iceChunk, 0.0f, 0.0f, tickDelta);
        this.model.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)iceChunk, f, tickDelta, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(IceologerIceChunkEntity iceologerIceChunk) {
        return TEXTURE;
    }
}

