/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.animation.AnimationDefinition;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationParser;
import com.google.common.collect.MapMaker;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

public final class AnimationLoader
extends class_4309 {
    public static final AnimationLoader INSTANCE = new AnimationLoader();
    private Map<class_2960, AnimationHolder> animations = new MapMaker().weakValues().concurrencyLevel(1).makeMap();
    private final List<AnimationHolder> strongHolderReferences = new ArrayList<AnimationHolder>();

    private AnimationLoader() {
        super(new Gson(), "friendsandfoes/animations/entity");
    }

    public Map<class_2960, AnimationHolder> getAnimations() {
        return this.animations;
    }

    public void setAnimations(Map<class_2960, AnimationHolder> animations) {
        this.animations = animations;
    }

    @Nullable
    public AnimationDefinition getAnimation(class_2960 key) {
        AnimationHolder holder = this.animations.get(key);
        return holder != null ? holder.getOrNull() : null;
    }

    public AnimationHolder getAnimationHolder(class_2960 key) {
        return this.animations.computeIfAbsent(key, AnimationHolder::new);
    }

    protected void apply(Map<class_2960, JsonElement> entityAnimationsJson, class_3300 resourceManager, class_3695 profiler) {
        HashMap<class_2960, AnimationDefinition> entityAnimations = new HashMap<class_2960, AnimationDefinition>();
        for (Map.Entry<class_2960, JsonElement> entry : entityAnimationsJson.entrySet()) {
            class_2960 resourceLocation = entry.getKey();
            JsonElement animationDefinitionJson = entry.getValue();
            AnimationDefinition animationDefinition = (AnimationDefinition)AnimationParser.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)animationDefinitionJson).getOrThrow();
            entityAnimations.put(resourceLocation, animationDefinition);
        }
        this.apply(entityAnimations);
    }

    public void apply(Map<class_2960, AnimationDefinition> entityAnimations) {
        this.animations.values().forEach(AnimationHolder::unbind);
        this.strongHolderReferences.clear();
        int loaded = 0;
        for (Map.Entry<class_2960, AnimationDefinition> entry : entityAnimations.entrySet()) {
            try {
                String animationName = entry.getKey().method_12832().substring(entry.getKey().method_12832().lastIndexOf(47) + 1);
                AnimationHolder animationHolder = this.getAnimationHolder(entry.getKey());
                AnimationDefinition parsedAnimation = entry.getValue();
                AnimationDefinition animation = new AnimationDefinition(animationName, parsedAnimation.lengthInSeconds(), parsedAnimation.looping(), parsedAnimation.boneAnimations());
                animationHolder.bind(animation);
                this.strongHolderReferences.add(animationHolder);
                ++loaded;
            }
            catch (Exception e) {
                FriendsAndFoes.getLogger().error("Failed to load animation {}", (Object)entry.getKey(), (Object)e);
            }
        }
        FriendsAndFoes.getLogger().info("Loaded {} entity animations", (Object)loaded);
    }
}

