/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.feature;

import com.faboslav.friendsandfoes.common.client.render.entity.model.PlayerIllusionEntityModel;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerIllusionCapeFeatureRenderer
extends RenderLayer<PlayerIllusionEntity, PlayerIllusionEntityModel<PlayerIllusionEntity>> {
    public PlayerIllusionCapeFeatureRenderer(RenderLayerParent<PlayerIllusionEntity, PlayerIllusionEntityModel<PlayerIllusionEntity>> arg) {
        super(arg);
    }

    public void render(PoseStack arg, MultiBufferSource arg2, int i, PlayerIllusionEntity arg3, float f, float g, float h, float j, float k, float l) {
        ItemStack itemStack;
        PlayerSkin skinTextures;
        if (!arg3.isInvisible() && arg3.isPartVisible(PlayerModelPart.CAPE) && (skinTextures = arg3.getSkinTextures()).capeTexture() != null && !(itemStack = arg3.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA)) {
            arg.pushPose();
            arg.translate(0.0f, 0.0f, 0.125f);
            double d = Mth.lerp((double)h, (double)arg3.prevCapeX, (double)arg3.capeX) - Mth.lerp((double)h, (double)arg3.xo, (double)arg3.getX());
            double e = Mth.lerp((double)h, (double)arg3.prevCapeY, (double)arg3.capeY) - Mth.lerp((double)h, (double)arg3.yo, (double)arg3.getY());
            double m = Mth.lerp((double)h, (double)arg3.prevCapeZ, (double)arg3.capeZ) - Mth.lerp((double)h, (double)arg3.zo, (double)arg3.getZ());
            float n = Mth.rotLerp((float)h, (float)arg3.yBodyRotO, (float)arg3.yBodyRot);
            double o = Mth.sin((float)(n * ((float)Math.PI / 180)));
            double p = -Mth.cos((float)(n * ((float)Math.PI / 180)));
            float q = (float)e * 10.0f;
            q = Mth.clamp((float)q, (float)-6.0f, (float)32.0f);
            float r = (float)(d * o + m * p) * 100.0f;
            r = Mth.clamp((float)r, (float)0.0f, (float)150.0f);
            float s = (float)(d * p - m * o) * 100.0f;
            s = Mth.clamp((float)s, (float)-20.0f, (float)20.0f);
            if (r < 0.0f) {
                r = 0.0f;
            }
            float t = Mth.lerp((float)h, (float)arg3.prevStrideDistance, (float)arg3.strideDistance);
            q += Mth.sin((float)(Mth.lerp((float)h, (float)arg3.walkDistO, (float)arg3.walkDist) * 6.0f)) * 32.0f * t;
            if (arg3.isCrouching()) {
                q += 25.0f;
            }
            arg.mulPose(Axis.XP.rotationDegrees(6.0f + r / 2.0f + q));
            arg.mulPose(Axis.ZP.rotationDegrees(s / 2.0f));
            arg.mulPose(Axis.YP.rotationDegrees(180.0f - s / 2.0f));
            VertexConsumer vertexConsumer = arg2.getBuffer(RenderType.entitySolid((ResourceLocation)skinTextures.capeTexture()));
            ((PlayerIllusionEntityModel)this.getParentModel()).renderCloak(arg, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
            arg.popPose();
        }
    }
}

