/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.util.animation.AnimationMath;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MaulerEntityModel<T extends MaulerEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_ROOT = "root";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_UPPER_JAW = "upperJaw";
    private static final String MODEL_PART_LOWER_JAW = "lowerJaw";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_FRONT_LEFT_LEG = "frontLeftLeg";
    private static final String MODEL_PART_FRONT_RIGHT_LEG = "frontRightLeg";
    private static final String MODEL_PART_BACK_LEFT_LEG = "backLeftLeg";
    private static final String MODEL_PART_BACK_RIGHT_LEG = "backRightLeg";
    private final ModelPart head;
    private final ModelPart upperJaw;
    private final ModelPart lowerJaw;
    private final ModelPart body;
    private final ModelPart frontLeftLeg;
    private final ModelPart frontRightLeg;
    private final ModelPart backLeftLeg;
    private final ModelPart backRightLeg;

    public MaulerEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.getChild(MODEL_PART_HEAD);
        this.upperJaw = this.head.getChild(MODEL_PART_UPPER_JAW);
        this.lowerJaw = this.head.getChild(MODEL_PART_LOWER_JAW);
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.frontLeftLeg = this.root.getChild(MODEL_PART_FRONT_LEFT_LEG);
        this.frontRightLeg = this.root.getChild(MODEL_PART_FRONT_RIGHT_LEG);
        this.backLeftLeg = this.root.getChild(MODEL_PART_BACK_LEFT_LEG);
        this.backRightLeg = this.root.getChild(MODEL_PART_BACK_RIGHT_LEG);
        this.setCurrentModelTransforms(MODEL_PART_ROOT, this.root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition head = root.getChild(MODEL_PART_HEAD);
        head.addOrReplaceChild(MODEL_PART_UPPER_JAW, CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -3.0f, -10.0f, 9.0f, 3.0f, 10.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0f));
        head.addOrReplaceChild(MODEL_PART_LOWER_JAW, CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, 0.0f, -10.0f, 9.0f, 3.0f, 10.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0f));
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(0, 26).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)20.0f, (float)1.0f));
        root.addOrReplaceChild(MODEL_PART_FRONT_LEFT_LEG, CubeListBuilder.create().texOffs(0, 5).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)2.5f, (float)21.0f, (float)-1.0f));
        root.addOrReplaceChild(MODEL_PART_FRONT_RIGHT_LEG, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)-2.5f, (float)21.0f, (float)-1.0f));
        root.addOrReplaceChild(MODEL_PART_BACK_LEFT_LEG, CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)2.5f, (float)21.0f, (float)3.0f));
        root.addOrReplaceChild(MODEL_PART_BACK_RIGHT_LEG, CubeListBuilder.create().texOffs(0, 13).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset((float)-2.5f, (float)21.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T mauler, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.applyModelTransforms(MODEL_PART_ROOT, this.root);
        float burrowingDownAnimationProgress = ((MaulerEntity)mauler).getBurrowingDownAnimationProgress();
        float maulerHeightWithOffset = 10.0f;
        if (burrowingDownAnimationProgress > 0.0f && burrowingDownAnimationProgress < 1.0f) {
            float targetY = maulerHeightWithOffset * burrowingDownAnimationProgress;
            this.animateModelPartYPositionBasedOnProgress((AnimatedEntity)mauler, this.root, targetY, AnimationMath.absSin(animationProgress));
            return;
        }
        if (((MaulerEntity)mauler).getBurrowingDownAnimationProgress() == 1.0f) {
            this.root.y = maulerHeightWithOffset;
            return;
        }
        this.head.xRot = headPitch * 0.005f;
        float baseSpeed = mauler.isAngry() ? 14.0f : 10.0f;
        float jumpHeight = mauler.isAngry() ? -4.5f : -2.5f;
        this.root.y = jumpHeight * Math.abs(Mth.triangleWave((float)limbAngle, (float)baseSpeed) * limbDistance);
        float legPitch = Mth.triangleWave((float)limbAngle, (float)baseSpeed) * limbDistance;
        float frontLegPitch = -1.5f * legPitch;
        float backLegPitch = 1.5f * legPitch;
        this.frontLeftLeg.xRot = frontLegPitch;
        this.frontRightLeg.xRot = frontLegPitch;
        this.backLeftLeg.xRot = backLegPitch;
        this.backRightLeg.xRot = backLegPitch;
        if (mauler.isAngry() && !((MaulerEntity)mauler).isBurrowedDown() && ((MaulerEntity)mauler).isMoving() && mauler.onGround() && mauler.getDeltaMovement().y() <= 1.0E-5) {
            float targetX = AnimationMath.toRadians(5.0) + AnimationMath.toRadians(-65.0) * AnimationMath.absSin(animationProgress, 1.0f, 0.35f);
            float delta = AnimationMath.absSin(animationProgress);
            MaulerEntityModel.animateModelPartXRotationBasedOnProgress(mauler, this.upperJaw, targetX, delta);
            MaulerEntityModel.animateModelPartXRotationBasedOnTicks(mauler, this.lowerJaw, AnimationMath.toRadians(-5.0), 10);
        } else {
            MaulerEntityModel.animateModelPartXRotationBasedOnTicks(mauler, this.upperJaw, 0.0f, 10);
            MaulerEntityModel.animateModelPartXRotationBasedOnTicks(mauler, this.lowerJaw, 0.0f, 10);
        }
    }
}

