/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem.CopperGolemLocateButtonTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem.CopperGolemPressButtonTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem.CopperGolemSpinHeadTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem.CopperGolemTravelToButtonTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class CopperGolemBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super CopperGolemEntity>>> SENSORS;
    private static final UniformInt SPIN_HEAD_COOLDOWN_PROVIDER;
    private static final UniformInt PRESS_BUTTON_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        CopperGolemBrain.addCoreActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addAvoidActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addIdleActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addPressButtonActivities((Brain<CopperGolemEntity>)brain);
        CopperGolemBrain.addSpinHeadActivities((Brain<CopperGolemEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<CopperGolemEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get()), (Object)new CountDownCooldownTicks(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get())));
    }

    private static void addPressButtonActivities(Brain<CopperGolemEntity> brain) {
        brain.addActivityWithConditions(FriendsAndFoesActivities.COPPER_GOLEM_PRESS_BUTTON.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CopperGolemLocateButtonTask())), (Object)Pair.of((Object)1, (Object)((Object)new CopperGolemTravelToButtonTask())), (Object)Pair.of((Object)2, (Object)((Object)new CopperGolemPressButtonTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addSpinHeadActivities(Brain<CopperGolemEntity> brain) {
        brain.addActivityWithConditions(FriendsAndFoesActivities.COPPER_GOLEM_SPIN_HEAD.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new CopperGolemSpinHeadTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void addAvoidActivities(Brain<CopperGolemEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.25f, (int)8, (boolean)true)), MemoryModuleType.AVOID_TARGET);
    }

    private static void addIdleActivities(Brain<CopperGolemEntity> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(copperGolem -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivities(CopperGolemEntity copperGolem) {
        copperGolem.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)FriendsAndFoesActivities.COPPER_GOLEM_PRESS_BUTTON.get(), (Object)FriendsAndFoesActivities.COPPER_GOLEM_SPIN_HEAD.get(), (Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static void setSpinHeadCooldown(CopperGolemEntity copperGolem) {
        copperGolem.getBrain().setMemory(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), (Object)SPIN_HEAD_COOLDOWN_PROVIDER.sample(copperGolem.getRandom()));
    }

    public static void setPressButtonCooldown(CopperGolemEntity copperGolem) {
        copperGolem.getBrain().setMemory(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)PRESS_BUTTON_COOLDOWN_PROVIDER.sample(copperGolem.getRandom()));
    }

    public static void setPressButtonCooldown(CopperGolemEntity copperGolem, UniformInt cooldown) {
        copperGolem.getBrain().setMemory(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), (Object)cooldown.sample(copperGolem.getRandom()));
    }

    public static Ingredient getTemptItems() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEYCOMB});
    }

    static {
        SENSORS = List.of(FriendsAndFoesSensorTypes.COPPER_GOLEM_TEMPTATIONS.get(), FriendsAndFoesSensorTypes.COPPER_GOLEM_SPECIFIC_SENSOR.get());
        MEMORY_MODULES = List.of(MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.AVOID_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get());
        SPIN_HEAD_COOLDOWN_PROVIDER = TimeUtil.rangeOfSeconds((int)8, (int)16);
        PRESS_BUTTON_COOLDOWN_PROVIDER = TimeUtil.rangeOfSeconds((int)15, (int)30);
    }
}

