/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class CrabGoToHomePositionTask
extends Behavior<CrabEntity> {
    private static final int GO_TO_HOME_POSITION_DURATION = 2400;

    public CrabGoToHomePositionTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), (Object)MemoryStatus.VALUE_PRESENT), 2400);
    }

    protected boolean shouldRun(ServerLevel world, CrabEntity crab) {
        return !crab.isCloseToHomePos(3.0f) && !crab.isLeashed() && !crab.isPassenger();
    }

    protected void run(ServerLevel serverWorld, CrabEntity crab, long l) {
        this.walkTowardsHomePos(crab);
    }

    protected boolean shouldKeepRunning(ServerLevel world, CrabEntity crab, long time) {
        return !crab.isAtHomePos() && !crab.isLeashed() && !crab.isPassenger();
    }

    protected void keepRunning(ServerLevel world, CrabEntity crab, long time) {
        if (crab.getNavigation().isInProgress()) {
            return;
        }
        this.walkTowardsHomePos(crab);
    }

    protected void finishRunning(ServerLevel world, CrabEntity crab, long time) {
        crab.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        crab.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    private void walkTowardsHomePos(CrabEntity crab) {
        BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)crab, (BlockPos)BlockPos.containing((Position)crab.getHomePos()), (float)1.0f, (int)0);
    }
}

