/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToDarkSpotTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import java.util.List;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public final class GlareBeGrumpyAtDarkSpotTask
extends Behavior<GlareEntity> {
    private static final int MAX_GRUMPY_TICKS = 200;
    private static final float WITHING_DISTANCE = 2.0f;
    private int grumpyTicks;
    private final ParticleOptions particleEffect = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.AZALEA.defaultBlockState());

    public GlareBeGrumpyAtDarkSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), MemoryStatus.VALUE_PRESENT), 200);
    }

    protected boolean shouldRun(ServerLevel world, GlareEntity glare) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return GlareBeGrumpyAtDarkSpotTask.canBeGrumpyAtDarkSpot(glare) && darkSpotPos.pos().closerToCenterThan((Position)glare.position(), 2.0);
    }

    protected void run(ServerLevel world, GlareEntity glare, long time) {
        this.grumpyTicks = 0;
        glare.setGrumpy(true);
        BehaviorUtils.lookAtEntity((LivingEntity)glare, (LivingEntity)glare.getOwner());
        this.applyGlowToHostileEntities(glare);
    }

    protected boolean shouldKeepRunning(ServerLevel world, GlareEntity glare, long time) {
        GlobalPos darkSpotPos = glare.getDarkSpotPos();
        return GlareBeGrumpyAtDarkSpotTask.canBeGrumpyAtDarkSpot(glare) && darkSpotPos.pos().closerToCenterThan((Position)glare.position(), 2.0);
    }

    protected void keepRunning(ServerLevel world, GlareEntity glare, long time) {
        ++this.grumpyTicks;
        BehaviorUtils.lookAtEntity((LivingEntity)glare, (LivingEntity)glare.getOwner());
        if (!glare.isGrumpy()) {
            glare.setGrumpy(true);
        }
        if (this.grumpyTicks == 10) {
            glare.playGrumpinessSound();
        }
        if (this.grumpyTicks % 3 == 0 && glare.getRandom().nextBoolean()) {
            glare.playRustleSound();
        }
        if (this.grumpyTicks % 2 == 0 && glare.getRandom().nextBoolean()) {
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.AZALEA.defaultBlockState());
            ParticleSpawner.spawnParticles((LivingEntity)glare, (ParticleOptions)particleEffect, glare.getRandom().nextIntBetweenInclusive(4, 10), 0.1);
        }
    }

    protected void finishRunning(ServerLevel world, GlareEntity glare, long time) {
        glare.setGrumpy(false);
        glare.getBrain().eraseMemory(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get());
        GlareBrain.setDarkSpotLocatingCooldown(glare);
    }

    private void applyGlowToHostileEntities(GlareEntity glare) {
        AABB box = new AABB(glare.blockPosition()).inflate(24.0);
        List hostileEntities = glare.level().getEntitiesOfClass(Monster.class, box);
        for (Monster hostileEntity : hostileEntities) {
            this.applyGlowToEntity(hostileEntity);
        }
    }

    private void applyGlowToEntity(Monster entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200));
    }

    public static boolean canBeGrumpyAtDarkSpot(GlareEntity glare) {
        return GlareTravelToDarkSpotTask.canTravelToDarkSpot(glare) && glare.getOwner() != null;
    }
}

