/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.wildfire;

import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class WildfireShockwaveAttackTask
extends Behavior<WildfireEntity> {
    private static final int SHOCKWAVE_DURATION = 20;
    private static final int SHOCKWAVE_PHASE_ONE_END_TICK = 15;
    public static final float SHOCKWAVE_ATTACK_RANGE = 6.0f;
    private int shockwaveTicks;
    private LivingEntity attackTarget;

    public WildfireShockwaveAttackTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.REGISTERED, FriendsAndFoesMemoryModuleTypes.WILDFIRE_SHOCKWAVE_ATTACK_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 20);
    }

    protected boolean shouldRun(ServerLevel world, WildfireEntity wildfire) {
        LivingEntity nearestTarget = wildfire.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = wildfire.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        }
        if (nearestTarget == null || wildfire.distanceTo((Entity)nearestTarget) > 6.0f || !nearestTarget.isAlive() || nearestTarget instanceof Player && (nearestTarget.isSpectator() || ((Player)nearestTarget).isCreative())) {
            return false;
        }
        this.attackTarget = nearestTarget;
        return true;
    }

    protected void run(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        wildfire.getNavigation().stop();
        BehaviorUtils.lookAtEntity((LivingEntity)wildfire, (LivingEntity)this.attackTarget);
        wildfire.getLookControl().setLookAt((Entity)this.attackTarget);
        WildfireBrain.setAttackTarget(wildfire, this.attackTarget);
        wildfire.playShockwaveSound();
        this.shockwaveTicks = 0;
    }

    protected boolean shouldKeepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        return this.shockwaveTicks <= 20;
    }

    protected void keepRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        wildfire.getLookControl().setLookAt((Entity)this.attackTarget);
        if (this.shockwaveTicks < 15) {
            wildfire.push(0.0, 0.075f, 0.0);
        } else if (this.shockwaveTicks == 15) {
            wildfire.setDeltaMovement(0.0, 0.0, 0.0);
        } else {
            wildfire.push(0.0, -1.0, 0.0);
        }
        wildfire.move(MoverType.SELF, wildfire.getDeltaMovement());
        if (this.shockwaveTicks == 20) {
            List closeEntities = wildfire.level().getEntities((Entity)wildfire, wildfire.getBoundingBox().inflate(6.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            for (Entity closeEntity : closeEntities) {
                if (closeEntity.getType().is(FriendsAndFoesTags.WILDFIRE_ALLIES)) continue;
                this.spawnShockwaveParticles(wildfire);
                wildfire.doHurtTarget(closeEntity);
            }
        }
        ++this.shockwaveTicks;
    }

    private void spawnShockwaveParticles(WildfireEntity wildfire) {
        Vec3 wildfirePosition = wildfire.position();
        ServerLevel serverWorld = (ServerLevel)wildfire.level();
        int waveAmount = 4;
        int particleAmount = 64;
        float slice = (float)Math.PI * 2 / (float)particleAmount;
        for (int radius = 1; radius < waveAmount; ++radius) {
            for (int particleNumber = 0; particleNumber < particleAmount; ++particleNumber) {
                float angle = slice * (float)particleNumber;
                int x = (int)(wildfirePosition.x() + (double)((float)radius * Mth.cos((float)angle)));
                int y = (int)wildfirePosition.y();
                int z = (int)(wildfirePosition.z() + (double)((float)radius * Mth.sin((float)angle)));
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x, (double)((float)y + 0.2f * (float)radius), (double)z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void finishRunning(ServerLevel world, WildfireEntity wildfire, long time) {
        WildfireBrain.setShockwaveAttackCooldown(wildfire);
    }
}

