/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.common.modcompat.ModChecker;
import com.faboslav.friendsandfoes.common.modcompat.ModCompat;
import com.faboslav.friendsandfoes.common.network.packet.TotemEffectPacket;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.TotemUtil;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract Iterable<ItemStack> getArmorSlots();

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void friendsandfoes_addToTick(CallbackInfo ci) {
        this.friendsandfoes_updateWildfireCrown();
    }

    private void friendsandfoes_updateWildfireCrown() {
        ItemStack itemStack = this.getItemBySlot(EquipmentSlot.HEAD);
        if (itemStack.is(FriendsAndFoesItems.WILDFIRE_CROWN.get()) && !this.isEyeInFluid(FluidTags.LAVA) && !this.isOnFire()) {
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 160, 0, false, false, true));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void friendsandfoes_tryUseTotems(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        ItemStack totemItemStack;
        PlayerEntityMixin entity = this;
        Player player = (Player)this;
        if (!(!player.isAlive() || source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.FALL) || source.is(DamageTypes.FALLING_BLOCK) || source.getEntity() == null || player.isDeadOrDying() || !(this.getHealth() <= this.getMaxHealth() / 2.0f) || (totemItemStack = PlayerEntityMixin.friendsandfoes_getTotem(PlayerEntityMixin.friendsandfoes_getTotemFromHands(player), PlayerEntityMixin.friendsandfoes_getTotemFromCustomEquipmentSlots(player))) == null)) {
            if (this instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)this;
                if (totemItemStack.getItem() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                    serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)FriendsAndFoesItems.TOTEM_OF_FREEZING.get()));
                } else if (totemItemStack.getItem() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                    serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()));
                }
                CriteriaTriggers.USED_TOTEM.trigger(serverPlayerEntity, totemItemStack);
            }
            Item totemItem = totemItemStack.getItem();
            this.removeAllEffects();
            TotemEffectPacket.sendToClient((Player)entity, totemItem);
            totemItemStack.shrink(1);
            if (totemItem == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                TotemUtil.freezeEntities(player);
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 1));
            } else if (totemItem == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                TotemUtil.createIllusions(player);
            }
        }
    }

    @Nullable
    private static ItemStack friendsandfoes_getTotem(ItemStack ... itemStacks) {
        return Arrays.stream(itemStacks).filter(Objects::nonNull).toList().stream().findFirst().orElse(null);
    }

    @Nullable
    private static ItemStack friendsandfoes_getTotemFromHands(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = player.getItemInHand(hand);
            if (!PlayerEntityMixin.friendsandfoes_isTotem(itemStack)) continue;
            return itemStack;
        }
        return null;
    }

    @Nullable
    private static ItemStack friendsandfoes_getTotemFromCustomEquipmentSlots(Player player) {
        for (ModCompat compat : ModChecker.CUSTOM_EQUIPMENT_SLOTS_COMPATS) {
            ItemStack itemStack = compat.getEquippedItemFromCustomSlots((Entity)player, PlayerEntityMixin::friendsandfoes_isTotem);
            if (itemStack == null) continue;
            return itemStack;
        }
        return null;
    }

    private static boolean friendsandfoes_isTotem(ItemStack itemStack) {
        return itemStack.is(FriendsAndFoesTags.TOTEMS);
    }
}

