/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.google.common.collect.ImmutableMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerHostilesSensor.class})
public final class VillagerHostilesSensorMixin {
    private static final ImmutableMap<EntityType<?>, Float> CUSTOM_SQUARED_DISTANCES_FOR_DANGER = ImmutableMap.builder().put(FriendsAndFoesEntityTypes.ICEOLOGER.get(), (Object)Float.valueOf(12.0f)).build();

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/ai/sensing/VillagerHostilesSensor;isClose(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/LivingEntity;)Z"}, cancellable=true)
    private void friendsandfoes_isCloseEnoughForDanger(LivingEntity villager, LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        if (CUSTOM_SQUARED_DISTANCES_FOR_DANGER.containsKey((Object)target.getType())) {
            float distance = ((Float)CUSTOM_SQUARED_DISTANCES_FOR_DANGER.get((Object)target.getType())).floatValue();
            boolean isCloseEnoughForDanger = target.distanceToSqr((Entity)villager) <= (double)(distance * distance);
            cir.setReturnValue((Object)isCloseEnoughForDanger);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/ai/sensing/VillagerHostilesSensor;isHostile(Lnet/minecraft/world/entity/LivingEntity;)Z"}, cancellable=true)
    private void friendsandfoes_isHostile(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (CUSTOM_SQUARED_DISTANCES_FOR_DANGER.containsKey((Object)entity.getType())) {
            cir.setReturnValue((Object)true);
        }
    }
}

