/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.modcompat;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.modcompat.ModCompat;
import com.faboslav.friendsandfoes.common.modcompat.neoforge.ModCheckerImpl;
import com.faboslav.friendsandfoes.common.platform.Platform;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public final class ModChecker {
    public static final List<ModCompat> CUSTOM_EQUIPMENT_SLOTS_COMPATS = new ArrayList<ModCompat>();

    public static void setupModCompat() {
        String modId = "";
        try {
            ModChecker.setupPlatformModCompat();
        }
        catch (Throwable e) {
            FriendsAndFoes.getLogger().error("Failed to setup compat with " + modId);
            e.printStackTrace();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupPlatformModCompat() {
        ModCheckerImpl.setupPlatformModCompat();
    }

    public static void loadModCompat(String modId, Supplier<ModCompat> loader) {
        try {
            ModCompat compat;
            if (Platform.isModLoaded(modId) && (compat = loader.get()).compatTypes().contains((Object)ModCompat.Type.CUSTOM_EQUIPMENT_SLOTS)) {
                CUSTOM_EQUIPMENT_SLOTS_COMPATS.add(compat);
            }
        }
        catch (Throwable e) {
            FriendsAndFoes.getLogger().error("Failed to load compat with " + modId);
            e.printStackTrace();
        }
    }
}

