/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.util;

import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class TotemUtil {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int NEGATIVE_EFFECT_TICKS = 400;
    public static final int POSITIVE_EFFECT_TICKS = 200;
    private static final Predicate<LivingEntity> FREEZE_FILTER = entity -> !(entity instanceof Player) || !((Player)entity).isCreative();
    private static final TargetingConditions FREEZE_TARGET_PREDICATE = TargetingConditions.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight().selector(FREEZE_FILTER);
    private static final TargetingConditions ATTACK_TARGET_PREDICATE = TargetingConditions.forNonCombat().ignoreInvisibilityTesting().ignoreLineOfSight();

    public static void playActivateAnimation(ItemStack itemStack, Entity entity, ParticleType<?> particleType) {
        Minecraft minecraftClient = Minecraft.getInstance();
        minecraftClient.particleEngine.createTrackingEmitter(entity, (ParticleOptions)particleType, 30);
        ClientLevel clientWorld = minecraftClient.level;
        if (clientWorld != null) {
            clientWorld.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
        }
        if (entity == minecraftClient.player) {
            minecraftClient.gameRenderer.displayItemActivation(itemStack);
        }
    }

    public static void freezeEntities(Player player) {
        List nearbyEntities = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(9.0), livingEntity -> FREEZE_TARGET_PREDICATE.test((LivingEntity)player, livingEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            nearbyEntity.setTicksFrozen(400);
            nearbyEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 1));
        });
    }

    public static void createIllusions(Player player) {
        player.playSound(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), 1.0f, player.getVoicePitch());
        Vec3 illusionerPosition = player.position();
        float slice = 0.69813174f;
        int radius = 9;
        ArrayList<PlayerIllusionEntity> createdPlayerIllusions = new ArrayList<PlayerIllusionEntity>();
        for (int point = 0; point < 9; ++point) {
            int z;
            int y;
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.x() + (double)((float)radius * Mth.cos((float)angle)));
            PlayerIllusionEntity createdPlayerIllusion = TotemUtil.createIllusion(player, x, y = (int)illusionerPosition.y(), z = (int)(illusionerPosition.z() + (double)((float)radius * Mth.sin((float)angle))));
            if (createdPlayerIllusion == null) continue;
            createdPlayerIllusions.add(createdPlayerIllusion);
        }
        List nearbyEntities = player.level().getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(18.0), mobEntity -> ATTACK_TARGET_PREDICATE.test((LivingEntity)player, (LivingEntity)mobEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            if (nearbyEntity.getTarget() == player) {
                if (!createdPlayerIllusions.isEmpty()) {
                    nearbyEntity.setAggressive(true);
                    nearbyEntity.setLastHurtByMob((LivingEntity)createdPlayerIllusions.get(player.getRandom().nextInt(createdPlayerIllusions.size())));
                    nearbyEntity.setLastHurtMob((Entity)createdPlayerIllusions.get(player.getRandom().nextInt(createdPlayerIllusions.size())));
                }
                nearbyEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 400, 1));
            }
        });
        if (!createdPlayerIllusions.isEmpty()) {
            LivingEntity attacker;
            PlayerIllusionEntity illusionToReplace = (PlayerIllusionEntity)((Object)createdPlayerIllusions.get(player.getRandom().nextInt(createdPlayerIllusions.size())));
            boolean teleportResult = TotemUtil.tryToTeleport(player, illusionToReplace.getBlockX(), illusionToReplace.getBlockY(), illusionToReplace.getBlockZ());
            if (teleportResult) {
                TotemUtil.spawnCloudParticles(player);
            }
            if ((attacker = illusionToReplace.getLastHurtByMob()) != null) {
                illusionToReplace.setLastHurtByPlayer(null);
                illusionToReplace.setLastHurtByMob(null);
                illusionToReplace.setLastHurtMob(null);
            }
            illusionToReplace.discard();
        }
        player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 200));
    }

    @Nullable
    private static PlayerIllusionEntity createIllusion(Player player, int x, int y, int z) {
        float randomYaw;
        PlayerIllusionEntity playerIllusion = (PlayerIllusionEntity)FriendsAndFoesEntityTypes.PLAYER_ILLUSION.get().create(player.level());
        if (playerIllusion == null) {
            return null;
        }
        playerIllusion.prevCapeX = player.xCloakO;
        playerIllusion.prevCapeY = player.yCloakO;
        playerIllusion.prevCapeZ = player.zCloakO;
        playerIllusion.capeX = player.xCloak;
        playerIllusion.capeY = player.yCloak;
        playerIllusion.capeZ = player.zCloak;
        playerIllusion.prevStrideDistance = player.oBob;
        playerIllusion.strideDistance = player.bob;
        playerIllusion.setItemSlot(EquipmentSlot.MAINHAND, player.getMainHandItem().copy());
        playerIllusion.setItemSlot(EquipmentSlot.OFFHAND, player.getOffhandItem().copy());
        player.getArmorSlots().forEach(item -> playerIllusion.equipItemIfPossible(item.copy()));
        playerIllusion.setHealth(player.getMaxHealth());
        playerIllusion.copyPosition((Entity)player);
        playerIllusion.yRotO = randomYaw = 360.0f * player.getRandom().nextFloat();
        playerIllusion.setYRot(randomYaw);
        playerIllusion.yBodyRotO = randomYaw;
        playerIllusion.setYBodyRot(randomYaw);
        playerIllusion.yHeadRotO = randomYaw;
        playerIllusion.setYHeadRot(randomYaw);
        playerIllusion.setPlayerUuid(player.getUUID());
        playerIllusion.setPlayer(player);
        playerIllusion.setTicksUntilDespawn(600);
        boolean teleportResult = playerIllusion.tryToTeleport(x, y, z);
        if (teleportResult) {
            player.level().addFreshEntity((Entity)playerIllusion);
            playerIllusion.spawnCloudParticles();
        }
        return playerIllusion;
    }

    private static boolean tryToTeleport(Player player, int x, int y, int z) {
        double bottomY = Math.max(y -= 8, player.level().getMinBuildHeight());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)player.level()).getLogicalHeight() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = player.randomTeleport((double)x, (double)(y = (int)Mth.clamp((double)(y + 1), (double)bottomY, (double)topY)), (double)z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private static void spawnCloudParticles(Player player) {
        TotemUtil.spawnParticles(player, ParticleTypes.CLOUD, 16);
    }

    private static void spawnParticles(Player player, SimpleParticleType particleType, int amount) {
        if (player.level().isClientSide()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)player.level()).sendParticles((ParticleOptions)particleType, player.getRandomX(0.5), player.getRandomY() + 0.5, player.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

