/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.world.spawner;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public final class IllusionerSpawner
implements CustomSpawner {
    private int cooldown;

    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        int maxZ;
        int maxX;
        int minZ;
        if (!(spawnMonsters && FriendsAndFoes.getConfig().enableIllusioner && FriendsAndFoes.getConfig().enableIllusionerSpawn)) {
            return 0;
        }
        RandomSource random = world.getRandom();
        --this.cooldown;
        if (this.cooldown > 0) {
            return 0;
        }
        this.cooldown += 12000 + random.nextInt(1000);
        long l = world.getDayTime() / 24000L;
        if (l < 5L || !world.isDay() || random.nextIntBetweenInclusive(0, 1) != 0) {
            return 0;
        }
        int playerCount = world.players().size();
        if (playerCount == 0) {
            return 0;
        }
        Player playerEntity = (Player)world.players().get(random.nextInt(playerCount));
        if (playerEntity.isSpectator() || world.isCloseToVillage(playerEntity.blockPosition(), 2)) {
            return 0;
        }
        int j = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        int k = (24 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        BlockPos.MutableBlockPos mutable = playerEntity.blockPosition().mutable().move(j, 0, k);
        int minX = mutable.getX() - 10;
        if (!world.hasChunksAt(minX, minZ = mutable.getZ() - 10, maxX = mutable.getX() + 10, maxZ = mutable.getZ() + 10)) {
            return 0;
        }
        if (!world.getBiome((BlockPos)mutable).is(FriendsAndFoesTags.HAS_ILLUSIONER)) {
            return 0;
        }
        mutable.setY(world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutable).getY());
        BlockState blockState = world.getBlockState((BlockPos)mutable);
        if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)world, (BlockPos)mutable, (BlockState)blockState, (FluidState)blockState.getFluidState(), (EntityType)EntityType.ILLUSIONER) || !PatrollingMonster.checkPatrollingMonsterSpawnRules((EntityType)EntityType.ILLUSIONER, (LevelAccessor)world, (MobSpawnType)MobSpawnType.PATROL, (BlockPos)mutable, (RandomSource)random)) {
            return 0;
        }
        Illusioner illusioner = (Illusioner)EntityType.ILLUSIONER.create((Level)world);
        if (illusioner == null) {
            return 0;
        }
        illusioner.setPatrolLeader(false);
        illusioner.findPatrolTarget();
        illusioner.setPos((double)mutable.getX(), (double)mutable.getY(), (double)mutable.getZ());
        illusioner.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt((BlockPos)mutable), MobSpawnType.PATROL, null);
        world.addFreshEntityWithPassengers((Entity)illusioner);
        return 1;
    }
}

