/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.fabric;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.events.AddItemGroupEntriesEvent;
import com.faboslav.friendsandfoes.common.events.entity.RegisterVillagerTradesEvent;
import com.faboslav.friendsandfoes.common.events.item.RegisterBrewingRecipesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.AddSpawnBiomeModificationsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterFlammabilityEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterReloadListenerEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.SetupEvent;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesStructurePoolElements;
import com.faboslav.friendsandfoes.common.util.ServerWorldSpawnersUtil;
import com.faboslav.friendsandfoes.common.world.spawner.IceologerSpawner;
import com.faboslav.friendsandfoes.common.world.spawner.IllusionerSpawner;
import com.faboslav.friendsandfoes.fabric.events.FabricReloadListener;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7134;
import net.minecraft.class_7923;
import net.minecraft.class_9168;
import org.apache.logging.log4j.util.TriConsumer;

public final class FriendsAndFoesFabric
implements ModInitializer {
    public void onInitialize() {
        FriendsAndFoes.init();
        FriendsAndFoesFabric.addCustomStructurePoolElements();
        FriendsAndFoesFabric.initEvents();
        FriendsAndFoes.lateInit();
    }

    private static void initEvents() {
        RegisterReloadListenerEvent.EVENT.invoke(new RegisterReloadListenerEvent((id, listener) -> ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricReloadListener((class_2960)id, (class_3302)listener))));
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> DatapackSyncEvent.EVENT.invoke(new DatapackSyncEvent(player)));
        ServerWorldEvents.LOAD.register((server, world) -> {
            FriendsAndFoesFabric.registerVillagerTrades();
            if (world.method_8608() || world.method_40134() != class_7134.field_37666) {
                return;
            }
            ServerWorldSpawnersUtil.register(world, new IceologerSpawner());
            ServerWorldSpawnersUtil.register(world, new IllusionerSpawner());
        });
        RegisterBrewingRecipesEvent.EVENT.invoke(new RegisterBrewingRecipesEvent((TriConsumer<class_6880<class_1842>, class_1792, class_6880<class_1842>>)((TriConsumer)(input, item, output) -> FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> builder.method_59705(input, item, output)))));
        RegisterFlammabilityEvent.EVENT.invoke(new RegisterFlammabilityEvent((arg_0, arg_1, arg_2) -> ((FlammableBlockRegistry)FlammableBlockRegistry.getDefaultInstance()).add(arg_0, arg_1, arg_2)));
        RegisterEntityAttributesEvent.EVENT.invoke(new RegisterEntityAttributesEvent(FabricDefaultAttributeRegistry::register));
        RegisterEntitySpawnRestrictionsEvent.EVENT.invoke(new RegisterEntitySpawnRestrictionsEvent(FriendsAndFoesFabric::registerPlacement));
        AddSpawnBiomeModificationsEvent.EVENT.invoke(new AddSpawnBiomeModificationsEvent((tag, spawnGroup, entityType, weight, minGroupSize, maxGroupSize) -> BiomeModifications.addSpawn(biomeSelector -> biomeSelector.hasTag(tag) && biomeSelector.hasTag(class_6908.field_37393), (class_1311)spawnGroup, (class_1299)entityType, (int)weight, (int)minGroupSize, (int)maxGroupSize)));
        SetupEvent.EVENT.invoke(new SetupEvent(Runnable::run));
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((itemGroup, entries) -> AddItemGroupEntriesEvent.EVENT.invoke(new AddItemGroupEntriesEvent(AddItemGroupEntriesEvent.Type.toType((class_5321<class_1761>)((class_5321)class_7923.field_44687.method_29113((Object)itemGroup).orElse(null))), itemGroup, itemGroup.method_47310(), arg_0 -> ((FabricItemGroupEntries)entries).method_45420(arg_0))));
    }

    private static void registerVillagerTrades() {
        Map trades = class_3853.field_17067;
        for (class_3852 profession : class_7923.field_41195) {
            int i;
            if (profession == null) continue;
            Int2ObjectMap profTrades = trades.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap listings = new Int2ObjectOpenHashMap();
            for (i = 1; i <= 5; ++i) {
                if (profTrades.containsKey(i)) {
                    List list = Arrays.stream((class_3853.class_1652[])profTrades.get(i)).collect(Collectors.toList());
                    listings.put(i, list);
                    continue;
                }
                listings.put(i, new ArrayList());
            }
            RegisterVillagerTradesEvent.EVENT.invoke(new RegisterVillagerTradesEvent(profession, (arg_0, arg_1) -> FriendsAndFoesFabric.lambda$registerVillagerTrades$9((Int2ObjectMap)listings, arg_0, arg_1)));
            for (i = 1; i <= 5; ++i) {
                profTrades.put(i, (Object)((List)listings.get(i)).toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private static <T extends class_1308> void registerPlacement(class_1299<T> type, RegisterEntitySpawnRestrictionsEvent.Placement<T> placement) {
        class_1317.method_20637(type, (class_9168)placement.location(), (class_2902.class_2903)placement.heightmap(), placement.predicate());
    }

    private static void addCustomStructurePoolElements() {
        ServerLifecycleEvents.SERVER_STARTING.register(FriendsAndFoesStructurePoolElements::init);
    }

    private static /* synthetic */ void lambda$registerVillagerTrades$9(Int2ObjectMap listings, Integer i, class_3853.class_1652 listing) {
        ((List)listings.get(i.intValue())).add(listing);
    }
}

