/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.fabric.mixin;

import com.faboslav.friendsandfoes.common.world.processor.StructureEntityProcessor;
import com.faboslav.friendsandfoes.common.world.processor.StructureProcessingContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3499.class})
public final class StructureEntityProcessorMixin {
    @Shadow
    @Final
    private List<class_3499.class_3502> field_15589;
    @Unique
    private static final ThreadLocal<StructureProcessingContext> friendsandfoes_context = new ThreadLocal();

    @Inject(method={"place"}, at={@At(value="INVOKE", target="Lnet/minecraft/structure/StructureTemplate;spawnEntities(Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/BlockMirror;Lnet/minecraft/util/BlockRotation;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockBox;Z)V")})
    private void friendsandfoes_captureContext(class_5425 world, class_2338 pos, class_2338 pivot, class_3492 placementData, class_5819 random, int flags, CallbackInfoReturnable<Boolean> cir) {
        friendsandfoes_context.set(new StructureProcessingContext(world, placementData, pos, pivot, this.field_15589));
    }

    @Inject(method={"place"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/structure/StructureTemplate;spawnEntities(Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/BlockMirror;Lnet/minecraft/util/BlockRotation;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockBox;Z)V")})
    private void friendsandfoes_clearContext(class_5425 serverLevelAccessor, class_2338 structurePiecePos, class_2338 structurePiecePivotPos, class_3492 structurePlaceSettings, class_5819 randomSource, int i, CallbackInfoReturnable<Boolean> cir) {
        friendsandfoes_context.remove();
    }

    @Inject(method={"place"}, at={@At(value="INVOKE", target="net/minecraft/structure/StructureTemplate.spawnEntities (Lnet/minecraft/world/ServerWorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/BlockMirror;Lnet/minecraft/util/BlockRotation;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockBox;Z)V")}, cancellable=true)
    private void friendsandfoes_processEntities(class_5425 serverWorldAccess, class_2338 structurePiecePos, class_2338 structurePieceBottomCenterPos, class_3492 structurePlacementData, class_5819 random, int flags, CallbackInfoReturnable<Boolean> cir) {
        StructureProcessingContext ctx = friendsandfoes_context.get();
        if (ctx.structurePlacementData().method_16182().stream().noneMatch(p -> p instanceof StructureEntityProcessor)) {
            return;
        }
        List<class_3499.class_3502> processedEntities = this.friendsandfoes_processEntityInfoList(ctx);
        for (class_3499.class_3502 entityInfo : processedEntities) {
            class_2338 entityBlockPos = entityInfo.field_15600;
            if (ctx.structurePlacementData().method_15124() != null && !ctx.structurePlacementData().method_15124().method_14662((class_2382)entityBlockPos)) continue;
            class_2487 entityNbt = entityInfo.field_15598.method_10553();
            class_243 entityPos = entityInfo.field_15599;
            class_2499 listTag = new class_2499();
            listTag.add((Object)class_2489.method_23241((double)entityPos.field_1352));
            listTag.add((Object)class_2489.method_23241((double)entityPos.field_1351));
            listTag.add((Object)class_2489.method_23241((double)entityPos.field_1350));
            entityNbt.method_10566("Pos", (class_2520)listTag);
            entityNbt.method_10551("UUID");
            StructureEntityProcessorMixin.friendsandfoes_tryCreateEntity(serverWorldAccess, entityNbt).ifPresent(entity -> {
                float f = entity.method_5763(ctx.structurePlacementData().method_15114());
                entity.method_5808(entityPos.field_1352, entityPos.field_1351, entityPos.field_1350, f += entity.method_36454() - entity.method_5832(ctx.structurePlacementData().method_15113()), entity.method_36455());
                if (ctx.structurePlacementData().method_27265() && entity instanceof class_1308) {
                    ((class_1308)entity).method_5943(serverWorldAccess, serverWorldAccess.method_8404(class_2338.method_49638((class_2374)entityPos)), class_3730.field_16474, null);
                }
                serverWorldAccess.method_30771(entity);
            });
        }
        cir.cancel();
    }

    @Unique
    private List<class_3499.class_3502> friendsandfoes_processEntityInfoList(StructureProcessingContext ctx) {
        ArrayList<class_3499.class_3502> processedEntities = new ArrayList<class_3499.class_3502>();
        class_5425 serverLevelAccessor = ctx.serverWorldAccess();
        class_2338 structurePiecePos = ctx.structurePiecePos();
        class_2338 structurePiecePivotPos = ctx.structurePiecePivotPos();
        class_3492 structurePlaceSettings = ctx.structurePlacementData();
        List<class_3499.class_3502> rawEntityInfos = ctx.rawEntityInfos();
        for (class_3499.class_3502 rawEntityInfo : rawEntityInfos) {
            class_3491 processor;
            class_243 globalPos = class_3499.method_15176((class_243)rawEntityInfo.field_15599, (class_2415)structurePlaceSettings.method_15114(), (class_2470)structurePlaceSettings.method_15113(), (class_2338)structurePlaceSettings.method_15134()).method_1019(class_243.method_24954((class_2382)structurePiecePos));
            class_2338 globalBlockPos = class_3499.method_15168((class_2338)rawEntityInfo.field_15600, (class_2415)structurePlaceSettings.method_15114(), (class_2470)structurePlaceSettings.method_15113(), (class_2338)structurePlaceSettings.method_15134()).method_10081((class_2382)structurePiecePos);
            class_3499.class_3502 globalEntityInfo = new class_3499.class_3502(globalPos, globalBlockPos, rawEntityInfo.field_15598);
            Iterator iterator = structurePlaceSettings.method_16182().iterator();
            while (iterator.hasNext() && (!((processor = (class_3491)iterator.next()) instanceof StructureEntityProcessor) || (globalEntityInfo = ((StructureEntityProcessor)processor).processEntity(serverLevelAccessor, structurePiecePos, structurePiecePivotPos, rawEntityInfo, globalEntityInfo, structurePlaceSettings)) != null)) {
            }
            if (globalEntityInfo == null) continue;
            processedEntities.add(globalEntityInfo);
        }
        return processedEntities;
    }

    @Unique
    private static Optional<class_1297> friendsandfoes_tryCreateEntity(class_5425 serverLevelAccessor, class_2487 compoundTag) {
        try {
            return class_1299.method_5892((class_2487)compoundTag, (class_1937)serverLevelAccessor.method_8410());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

