/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.fabric.network;

import com.faboslav.friendsandfoes.common.network.Packet;
import com.faboslav.friendsandfoes.common.network.base.ClientboundPacketType;
import com.faboslav.friendsandfoes.common.network.base.Networking;
import com.faboslav.friendsandfoes.common.network.base.PacketType;
import com.faboslav.friendsandfoes.common.network.base.ServerboundPacketType;
import com.faboslav.friendsandfoes.common.network.internal.NetworkPacketPayload;
import com.faboslav.friendsandfoes.fabric.network.FabricClientNetworkHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class FabricNetworking
implements Networking {
    private static final boolean IS_CLIENT = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
    private final class_2960 channel;

    public FabricNetworking(class_2960 channel, int protocolVersion) {
        this.channel = channel.method_48331("/v" + protocolVersion);
    }

    @Override
    public <T extends Packet<T>> void register(ClientboundPacketType<T> type) {
        class_8710.class_9154 payloadType = type.type(this.channel);
        PayloadTypeRegistry.playS2C().register(payloadType, type.codec(payloadType));
        if (!IS_CLIENT) {
            return;
        }
        FabricClientNetworkHandler.register(payloadType, type);
    }

    @Override
    public <T extends Packet<T>> void register(ServerboundPacketType<T> type) {
        class_8710.class_9154 payloadType = type.type(this.channel);
        PayloadTypeRegistry.playC2S().register(payloadType, type.codec(payloadType));
        ServerPlayNetworking.registerGlobalReceiver(payloadType, (payload, context) -> type.handle(payload.packet()).accept((class_1657)context.player()));
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T message) {
        if (!IS_CLIENT) {
            return;
        }
        FabricClientNetworkHandler.send(this.channel, message);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, new NetworkPacketPayload<T>(message, this.channel));
    }

    @Override
    public boolean canSendToPlayer(class_3222 player, PacketType<?> type) {
        return ServerPlayNetworking.canSend((class_3222)player, type.type(this.channel));
    }
}

