/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;

public interface FriendsAndFoesOxidizable
extends WeatheringCopper {
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)FriendsAndFoesBlocks.COPPER_BUTTON.get(), (Object)FriendsAndFoesBlocks.EXPOSED_COPPER_BUTTON.get()).put((Object)FriendsAndFoesBlocks.EXPOSED_COPPER_BUTTON.get(), (Object)FriendsAndFoesBlocks.WEATHERED_COPPER_BUTTON.get()).put((Object)FriendsAndFoesBlocks.WEATHERED_COPPER_BUTTON.get(), (Object)FriendsAndFoesBlocks.OXIDIZED_COPPER_BUTTON.get()).put((Object)Blocks.LIGHTNING_ROD, (Object)FriendsAndFoesBlocks.EXPOSED_LIGHTNING_ROD.get()).put((Object)FriendsAndFoesBlocks.EXPOSED_LIGHTNING_ROD.get(), (Object)FriendsAndFoesBlocks.WEATHERED_LIGHTNING_ROD.get()).put((Object)FriendsAndFoesBlocks.WEATHERED_LIGHTNING_ROD.get(), (Object)FriendsAndFoesBlocks.OXIDIZED_LIGHTNING_ROD.get()).build());
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_DECREASES = Suppliers.memoize(() -> OXIDATION_LEVEL_INCREASES.get().inverse());

    public static Optional<Block> getDecreasedOxidationBlock(Block block) {
        return Optional.ofNullable((Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Block getUnaffectedOxidationBlock(Block block) {
        Block block2 = block;
        Block block3 = (Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)OXIDATION_LEVEL_DECREASES.get().get((Object)block3);
        }
        return block2;
    }

    public static Optional<BlockState> getDecreasedOxidationState(BlockState state) {
        return FriendsAndFoesOxidizable.getDecreasedOxidationBlock(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    public static Optional<Block> getIncreasedOxidationBlock(Block block) {
        return Optional.ofNullable((Block)OXIDATION_LEVEL_INCREASES.get().get((Object)block));
    }

    public static BlockState getUnaffectedOxidationState(BlockState state) {
        return FriendsAndFoesOxidizable.getUnaffectedOxidationBlock(state.getBlock()).withPropertiesOf(state);
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return FriendsAndFoesOxidizable.getIncreasedOxidationBlock(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return this.getAge() == WeatheringCopper.WeatherState.UNAFFECTED ? 0.75f : 1.0f;
    }
}

