/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.feature;

import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MoobloomFlowerFeatureRenderer<T extends MoobloomEntity>
extends RenderLayer<T, CowModel<T>> {
    private final BlockRenderDispatcher blockRenderManager = Minecraft.getInstance().getBlockRenderer();

    public MoobloomFlowerFeatureRenderer(RenderLayerParent<T, CowModel<T>> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, T moobloomEntity, float f, float g, float h, float j, float k, float l) {
        if (!moobloomEntity.isBaby() && !moobloomEntity.isInvisible()) {
            Minecraft minecraftClient;
            BushBlock flower = ((MoobloomEntity)((Object)moobloomEntity)).getVariant().getFlower();
            BlockState blockState = ((MoobloomEntity)((Object)moobloomEntity)).getVariant().getFlower().defaultBlockState();
            if (flower instanceof DoublePlantBlock) {
                blockState = (BlockState)((MoobloomEntity)((Object)moobloomEntity)).getVariant().getFlower().defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
            }
            int overlay = LivingEntityRenderer.getOverlayCoords(moobloomEntity, (float)0.0f);
            float scaleFactor = 0.8f;
            float yOffset = -0.5f;
            if (flower instanceof DoublePlantBlock) {
                scaleFactor = 0.6f;
                yOffset = -0.666f;
            }
            boolean renderAsModel = (minecraftClient = Minecraft.getInstance()).shouldEntityAppearGlowing(moobloomEntity) && moobloomEntity.isInvisible();
            BakedModel bakedModel = this.blockRenderManager.getBlockModel(blockState);
            matrixStack.pushPose();
            ((CowModel)this.getParentModel()).getHead().translateAndRotate(matrixStack);
            matrixStack.translate(0.09, -0.6, -0.185);
            matrixStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            matrixStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(matrixStack, vertexConsumerProvider, light, renderAsModel, blockState, overlay, bakedModel);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(0.22, -0.28, -0.06);
            matrixStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            matrixStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(matrixStack, vertexConsumerProvider, light, renderAsModel, blockState, overlay, bakedModel);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(-0.2, -0.22, 0.01);
            matrixStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            matrixStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(matrixStack, vertexConsumerProvider, light, renderAsModel, blockState, overlay, bakedModel);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(0.03, -0.28, 0.47);
            matrixStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            matrixStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(matrixStack, vertexConsumerProvider, light, renderAsModel, blockState, overlay, bakedModel);
            matrixStack.popPose();
        }
    }

    private void renderFlower(PoseStack matrices, MultiBufferSource vertexConsumers, int light, boolean renderAsModel, BlockState moobloomState, int overlay, BakedModel moobloomModel) {
        if (renderAsModel) {
            this.blockRenderManager.getModelRenderer().renderModel(matrices.last(), vertexConsumers.getBuffer(RenderType.outline((ResourceLocation)InventoryMenu.BLOCK_ATLAS)), moobloomState, moobloomModel, 0.0f, 0.0f, 0.0f, light, overlay);
        } else {
            this.blockRenderManager.renderSingleBlock(moobloomState, matrices, vertexConsumers, light, overlay);
        }
    }
}

