/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.common.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.AnimationState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CopperGolemEntityModel<T extends CopperGolemEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_NOSE = "nose";
    private static final String MODEL_PART_ROD = "rod";
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart rod;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public CopperGolemEntityModel(ModelPart root) {
        super(root);
        this.body = this.root.getChild(MODEL_PART_BODY);
        this.head = this.body.getChild(MODEL_PART_HEAD);
        this.nose = this.head.getChild(MODEL_PART_NOSE);
        this.rod = this.head.getChild(MODEL_PART_ROD);
        this.leftArm = this.body.getChild(MODEL_PART_LEFT_ARM);
        this.rightArm = this.body.getChild(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.getChild(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.getChild(MODEL_PART_RIGHT_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        root.addOrReplaceChild(MODEL_PART_BODY, CubeListBuilder.create().texOffs(40, 0).addBox(-4.0f, -5.0f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.getChild(MODEL_PART_BODY);
        body.addOrReplaceChild(MODEL_PART_HEAD, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -5.0f, -4.0f, 8.0f, 5.0f, 8.0f, new CubeDeformation(0.001f)).mirror(false), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition head = body.getChild(MODEL_PART_HEAD);
        head.addOrReplaceChild(MODEL_PART_ROD, CubeListBuilder.create().texOffs(56, 10).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 9).addBox(-2.0f, -7.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        head.addOrReplaceChild(MODEL_PART_NOSE, CubeListBuilder.create().texOffs(56, 15).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-4.0f));
        body.addOrReplaceChild(MODEL_PART_LEFT_ARM, CubeListBuilder.create().texOffs(10, 17).addBox(0.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-5.0f, (float)0.0f));
        body.addOrReplaceChild(MODEL_PART_RIGHT_ARM, CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-5.0f, (float)0.0f));
        root.addOrReplaceChild(MODEL_PART_LEFT_LEG, CubeListBuilder.create().texOffs(34, 17).addBox(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)19.0f, (float)0.0f));
        root.addOrReplaceChild(MODEL_PART_RIGHT_LEG, CubeListBuilder.create().texOffs(20, 17).addBox(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T copperGolem, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            animationProgress = ((CopperGolemEntity)copperGolem).tickCount;
        }
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngle(headYaw);
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            this.updateStatueKeyframeAnimation((CopperGolemEntity)copperGolem);
        }
        this.updateMovementKeyframeAnimations((AnimatedEntity)copperGolem, limbAngle, limbDistance, 2.5f * ((CopperGolemEntity)copperGolem).getAnimationSpeedModifier(), 3.5f * ((CopperGolemEntity)copperGolem).getAnimationSpeedModifier());
        this.updateKeyframeAnimations((AnimatedEntity)copperGolem, animationProgress);
    }

    private void setHeadAngle(float yaw) {
        this.head.yRot = yaw * ((float)Math.PI / 180);
    }

    private void updateStatueKeyframeAnimation(CopperGolemEntity copperGolem) {
        if (copperGolem.isInPose(CopperGolemEntityPose.IDLE)) {
            return;
        }
        KeyframeAnimation keyframeAnimation = copperGolem.getKeyframeAnimationByPose();
        if (keyframeAnimation == null) {
            return;
        }
        int initialTick = copperGolem.tickCount - copperGolem.getCurrentKeyframeAnimationTick();
        int currentTick = copperGolem.tickCount;
        AnimationContextTracker animationContextTracker = copperGolem.getAnimationContextTracker();
        KeyframeAnimationContext keyframeAnimationContext = animationContextTracker.get(keyframeAnimation);
        keyframeAnimationContext.setInitialTick(initialTick);
        keyframeAnimationContext.setCurrentTick(currentTick);
        AnimationState animationState = new AnimationState();
        keyframeAnimationContext.setAnimationState(animationState);
        animationState.start(initialTick);
    }
}

