/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CopperGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.mixin.LimbAnimatorAccessor;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemEntity
extends AbstractGolem
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final float MOVEMENT_SPEED = 0.2f;
    private static final int COPPER_INGOT_HEAL_AMOUNT = 5;
    private static final float SPARK_CHANCE = 0.025f;
    private static final float OXIDATION_CHANCE = 2.0E-5f;
    public static final int MIN_STRUCT_BY_LIGHTNING_TICKS = 1200;
    public static final int MAX_STRUCT_BY_LIGHTNING_TICKS = 2400;
    private static final String POSE_NBT_NAME = "Pose";
    private static final String POSE_TICKS_NBT_NAME = "PoseTicks";
    private static final String OXIDATION_LEVEL_NBT_NAME = "OxidationLevel";
    private static final String IS_WAXED_NBT_NAME = "IsWaxed";
    private static final String ENTITY_SNAPSHOT_NBT_NAME = "EntitySnapshot";
    private static final EntityDataAccessor<Integer> OXIDATION_LEVEL = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STRUCT_BY_LIGHTNING_TICKS = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> WAS_STATUE = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_WAXED = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<CompoundTag> ENTITY_SNAPSHOT = SynchedEntityData.defineId(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.refreshAnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    private void refreshAnimationContextTracker() {
        this.animationContextTracker = new AnimationContextTracker();
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            this.animationContextTracker.add(keyframeAnimation);
        }
        this.animationContextTracker.add(this.getMovementAnimation());
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return CopperGolemAnimations.getAnimations(this.getAnimationSpeedModifier());
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return CopperGolemAnimations.getWalkKeyframeAnimation(this.getAnimationSpeedModifier());
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.entityData.get(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.entityData.set(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    public CopperGolemEntity(EntityType<? extends CopperGolemEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new CopperGolemMoveControl(this);
        this.lookControl = new CopperGolemLookControl(this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        SpawnGroupData superEntityData = super.finalizeSpawn(world, difficulty, spawnReason, entityData, entityNbt);
        if (spawnReason == MobSpawnType.STRUCTURE) {
            return superEntityData;
        }
        this.setPose(CopperGolemEntityPose.IDLE);
        CopperGolemBrain.setSpinHeadCooldown(this);
        CopperGolemBrain.setPressButtonCooldown(this);
        return superEntityData;
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(POSE_TICKS, (Object)0);
        this.entityData.define(OXIDATION_LEVEL, (Object)WeatheringCopper.WeatherState.UNAFFECTED.ordinal());
        this.entityData.define(STRUCT_BY_LIGHTNING_TICKS, (Object)0);
        this.entityData.define(WAS_STATUE, (Object)false);
        this.entityData.define(IS_WAXED, (Object)false);
        this.entityData.define(ENTITY_SNAPSHOT, (Object)new CompoundTag());
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt(OXIDATION_LEVEL_NBT_NAME, this.getOxidationLevel().ordinal());
        nbt.putBoolean(IS_WAXED_NBT_NAME, this.isWaxed());
        if (this.isOxidized()) {
            nbt.putString(POSE_NBT_NAME, this.getPose().name());
            nbt.putInt(POSE_TICKS_NBT_NAME, this.getKeyframeAnimationTicks());
            nbt.put(ENTITY_SNAPSHOT_NBT_NAME, (Tag)this.getEntitySnapshot());
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains(POSE_NBT_NAME)) {
            Pose entityPose = Pose.valueOf((String)nbt.getString(POSE_NBT_NAME));
            this.setPose(entityPose);
        }
        if (nbt.contains(POSE_TICKS_NBT_NAME)) {
            this.setKeyframeAnimationTicks(nbt.getInt(POSE_TICKS_NBT_NAME));
        }
        if (nbt.contains(OXIDATION_LEVEL_NBT_NAME)) {
            this.setOxidationLevel(WeatheringCopper.WeatherState.values()[nbt.getInt(OXIDATION_LEVEL_NBT_NAME)]);
        }
        if (nbt.contains(IS_WAXED_NBT_NAME)) {
            this.setIsWaxed(nbt.getBoolean(IS_WAXED_NBT_NAME));
        }
        if (nbt.contains(ENTITY_SNAPSHOT_NBT_NAME)) {
            this.setEntitySnapshot(nbt.getCompound(ENTITY_SNAPSHOT_NBT_NAME));
            this.applyEntitySnapshot();
        }
    }

    public static AttributeSupplier.Builder createCopperGolemAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CopperGolemBrain.create(dynamic);
    }

    public Brain<CopperGolemEntity> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void setEntitySnapshot(CompoundTag entitySnapshot) {
        this.entityData.set(ENTITY_SNAPSHOT, (Object)entitySnapshot);
    }

    public void applyEntitySnapshot() {
        CompoundTag entitySnapshot = this.getEntitySnapshot();
        if (entitySnapshot.isEmpty()) {
            return;
        }
        if (!this.isPassenger()) {
            this.lerpYRot = entitySnapshot.getDouble("serverYaw");
            this.yRotO = entitySnapshot.getFloat("prevYaw");
            this.setYRot(this.yRotO);
            this.yBodyRot = this.yBodyRotO = entitySnapshot.getFloat("prevBodyYaw");
            this.lerpYHeadRot = entitySnapshot.getDouble("serverHeadYaw");
            this.yHeadRot = this.yHeadRotO = entitySnapshot.getFloat("prevHeadYaw");
            this.animStep = this.animStepO = entitySnapshot.getFloat("prevLookDirection");
        }
        this.xRotO = entitySnapshot.getFloat("prevPitch");
        this.lerpXRot = this.xRotO;
        this.setXRot(this.xRotO);
        this.fallFlyTicks = entitySnapshot.getInt("roll");
        this.attackAnim = this.oAttackAnim = entitySnapshot.getFloat("lastHandSwingProgress");
        ((LimbAnimatorAccessor)this.walkAnimation).setPrevSpeed(entitySnapshot.getFloat("limbAnimatorPrevSpeed"));
        this.walkAnimation.setSpeed(entitySnapshot.getFloat("limbAnimatorSpeed"));
        ((LimbAnimatorAccessor)this.walkAnimation).setPos(entitySnapshot.getFloat("limbAnimatorPos"));
        this.run = this.oRun = entitySnapshot.getFloat("prevStepBobbingAmount");
    }

    public CompoundTag getEntitySnapshot() {
        return (CompoundTag)this.entityData.get(ENTITY_SNAPSHOT);
    }

    private CompoundTag takeEntitySnapshot() {
        CompoundTag entitySnapshot = new CompoundTag();
        entitySnapshot.putDouble("serverYaw", this.lerpYRot);
        entitySnapshot.putFloat("prevYaw", this.yRotO);
        entitySnapshot.putDouble("serverPitch", this.lerpXRot);
        entitySnapshot.putFloat("prevPitch", this.xRotO);
        entitySnapshot.putInt("roll", this.getFallFlyingTicks());
        entitySnapshot.putFloat("prevBodyYaw", this.yBodyRotO);
        entitySnapshot.putDouble("serverHeadYaw", this.lerpYHeadRot);
        entitySnapshot.putFloat("prevHeadYaw", this.yHeadRotO);
        entitySnapshot.putFloat("lastHandSwingProgress", this.oAttackAnim);
        entitySnapshot.putFloat("limbAnimatorPrevSpeed", ((LimbAnimatorAccessor)this.walkAnimation).getPresSpeed());
        entitySnapshot.putFloat("limbAnimatorSpeed", this.walkAnimation.speed());
        entitySnapshot.putFloat("limbAnimatorPos", this.walkAnimation.position());
        entitySnapshot.putFloat("prevLookDirection", this.animStepO);
        entitySnapshot.putFloat("prevStepBobbingAmount", this.oRun);
        return entitySnapshot;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public float getVoicePitch() {
        return (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 2.5f;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.isImmobilized() || state.liquid()) {
            return;
        }
        BlockState blockState = this.level().getBlockState(pos.above());
        SoundType blockSoundGroup = blockState.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) ? blockState.getSoundType() : state.getSoundType();
        this.playSound(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_STEP.get(), blockSoundGroup.getVolume() * 0.15f, this.getVoicePitch());
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity attacker = source.getEntity();
        if (attacker instanceof LightningBolt || source == this.damageSources().sweetBerryBush()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)this.getEyeHeight() * 0.45, 0.0);
    }

    protected float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return 0.75f;
    }

    public float getMovementSpeedModifier() {
        if (this.isStructByLightning()) {
            return 1.5f;
        }
        return (0.2f - (float)this.getOxidationModifier() * 0.033333335f) / 0.2f;
    }

    public float getAnimationSpeedModifier() {
        if (this.isStructByLightning()) {
            return 0.6666666f;
        }
        return 0.2f / (0.2f - (float)this.getOxidationModifier() * 0.033333335f);
    }

    private int getOxidationModifier() {
        return Math.min(this.getOxidationLevel().ordinal(), WeatheringCopper.WeatherState.WEATHERED.ordinal());
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item itemInHand = itemStack.getItem();
        boolean interactionResult = false;
        if (itemInHand == Items.COPPER_INGOT) {
            interactionResult = this.tryToInteractMobWithCopperIngot(player, itemStack);
        } else if (itemInHand == Items.HONEYCOMB) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof AxeItem) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (interactionResult) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, (Entity)this);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    private boolean tryToInteractMobWithCopperIngot(Player player, ItemStack itemStack) {
        if (this.getHealth() == this.getMaxHealth()) {
            return false;
        }
        this.heal(5.0f);
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        this.playSound(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_REPAIR.get(), 1.0f, this.getVoicePitch() - 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(Player player, ItemStack itemStack) {
        if (this.isWaxed() || this.isImmobilized()) {
            return false;
        }
        this.setIsWaxed(true);
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        this.playSound(SoundEvents.HONEYCOMB_WAX_ON, 1.0f, 1.0f);
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.WAX_ON, 7, 1.0);
        return true;
    }

    private boolean tryToInteractMobWithAxe(Player player, InteractionHand hand, ItemStack itemStack) {
        if (!this.isWaxed() && !this.isDegraded() || this.wasStatue() && !this.isOxidized()) {
            return false;
        }
        if (this.isWaxed()) {
            this.setIsWaxed(false);
            this.playSound(SoundEvents.AXE_WAX_OFF, 1.0f, 1.0f);
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.WAX_OFF, 7, 1.0);
        } else if (this.isDegraded()) {
            if (!this.level().isClientSide()) {
                int increasedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() - 1;
                WeatheringCopper.WeatherState[] OxidationLevels = WeatheringCopper.WeatherState.values();
                this.setOxidationLevel(OxidationLevels[increasedOxidationLevelOrdinal]);
            }
            this.playSound(SoundEvents.AXE_SCRAPE, 1.0f, 1.0f);
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.SCRAPE, 7, 1.0);
        }
        if (!this.level().isClientSide() && !player.getAbilities().instabuild) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, playerEntity -> player.broadcastBreakEvent(hand));
        }
        return true;
    }

    protected void customServerAiStep() {
        if (this.isImmobilized()) {
            super.customServerAiStep();
            return;
        }
        this.level().getProfiler().push("copperGolemBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("copperGolemActivityUpdate");
        CopperGolemBrain.updateActivities(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void tick() {
        if (!FriendsAndFoes.getConfig().enableCopperGolem) {
            this.discard();
        }
        this.updateKeyframeAnimations();
        super.tick();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
            MovementUtil.stopMovement((Mob)this);
            return;
        }
        if (this.isStructByLightning() && !this.getCommandSenderWorld().isClientSide()) {
            this.setStructByLightningTicks(this.getStructByLightningTicks() - 1);
            if (this.getRandom().nextFloat() < 0.025f) {
                for (int i = 0; i < 7; ++i) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, this.getRandomX(0.35), this.getRandomY() + 0.25, this.getRandomZ(0.35), 1, this.getRandom().nextGaussian() * 0.01, this.getRandom().nextGaussian() * 0.01, this.getRandom().nextGaussian() * 0.01, 0.1);
                }
            }
        }
        this.handleOxidationIncrease();
    }

    public boolean isPushable() {
        return !this.isImmobilized();
    }

    public void thunderHit(ServerLevel serverWorld, LightningBolt lightning) {
        super.thunderHit(serverWorld, lightning);
        this.setRemainingFireTicks(0);
        this.setSharedFlagOnFire(false);
        this.setHealth(this.getMaxHealth());
        if (this.isDegraded()) {
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)ParticleTypes.WAX_OFF, 7, 1.0);
        }
        if (!this.getCommandSenderWorld().isClientSide()) {
            this.refreshStructByLightningTicks();
            if (!this.isWaxed()) {
                this.setOxidationLevel(WeatheringCopper.WeatherState.UNAFFECTED);
            }
        }
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.level().isClientSide() && !this.isOxidized()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
            this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Override
    public void updateKeyframeAnimationTicks() {
        if (!this.isAnyKeyframeAnimationRunning()) {
            return;
        }
        this.setKeyframeAnimationTicks(this.getKeyframeAnimationTicks() - 1);
        if (!this.level().isClientSide() && this.wasStatue() && this.getKeyframeAnimationTicks() == 1) {
            this.setPose(CopperGolemEntityPose.IDLE);
            this.setWasStatue(false);
        }
        if (this.getKeyframeAnimationTicks() > 1) {
            return;
        }
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            KeyframeAnimationContext keyframeAnimationContext;
            if (!keyframeAnimation.getAnimation().looping() || !(keyframeAnimationContext = this.getAnimationContextTracker().get(keyframeAnimation)).isRunning()) continue;
            this.setKeyframeAnimationTicks(keyframeAnimation.getAnimationLengthInTicks());
        }
    }

    @Nullable
    public KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.isInPose(CopperGolemEntityPose.IDLE)) {
            keyframeAnimation = CopperGolemAnimations.IDLE;
        } else if (this.isInPose(CopperGolemEntityPose.SPIN_HEAD)) {
            keyframeAnimation = CopperGolemAnimations.getSpinHeadKeyframeAnimation(this.getAnimationSpeedModifier());
        } else if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_UP)) {
            keyframeAnimation = CopperGolemAnimations.getPressButtonUpKeyframeAnimation(this.getAnimationSpeedModifier());
        } else if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN)) {
            keyframeAnimation = CopperGolemAnimations.getPressButtonDownKeyframeAnimation(this.getAnimationSpeedModifier());
        }
        return keyframeAnimation;
    }

    public int getCurrentKeyframeAnimationTick() {
        KeyframeAnimation keyframeAnimation = this.getKeyframeAnimationByPose();
        if (keyframeAnimation == null) {
            return 0;
        }
        int totalAnimationTicks = keyframeAnimation.getAnimationLengthInTicks();
        int leftAnimationTicks = this.getKeyframeAnimationTicks();
        return totalAnimationTicks - leftAnimationTicks;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.level().isClientSide() && !this.isOxidized()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        int initialTick = this.isOxidized() ? this.tickCount - this.getCurrentKeyframeAnimationTick() : this.tickCount;
        this.startKeyframeAnimation(keyframeAnimationToStart, initialTick);
    }

    public void setPose(Pose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        super.setPose(pose);
    }

    public void setPose(CopperGolemEntityPose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        super.setPose(pose.get());
    }

    public boolean isInPose(CopperGolemEntityPose pose) {
        return this.getPose() == pose.get();
    }

    public void startSpinHeadAnimation() {
        if (this.isInPose(CopperGolemEntityPose.SPIN_HEAD)) {
            return;
        }
        this.playSound(FriendsAndFoesSoundEvents.ENTITY_COPPER_GOLEM_HEAD_SPIN.get(), 1.0f, this.getVoicePitch() - 1.5f);
        this.setPose(CopperGolemEntityPose.SPIN_HEAD);
    }

    public void startPressButtonUpAnimation() {
        if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_UP)) {
            return;
        }
        this.setPose(CopperGolemEntityPose.PRESS_BUTTON_UP);
    }

    public void startPressButtonDownAnimation() {
        if (this.isInPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN)) {
            return;
        }
        this.setPose(CopperGolemEntityPose.PRESS_BUTTON_DOWN);
    }

    public void handleOxidationIncrease() {
        if (this.getCommandSenderWorld().isClientSide() || this.isImmobilized() || this.isWaxed()) {
            return;
        }
        if (this.getRandom().nextFloat() < 2.0E-5f) {
            int degradedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() + 1;
            WeatheringCopper.WeatherState[] OxidationLevels = WeatheringCopper.WeatherState.values();
            this.setOxidationLevel(OxidationLevels[degradedOxidationLevelOrdinal]);
        }
    }

    public boolean isOxidized() {
        return this.getOxidationLevel() == WeatheringCopper.WeatherState.OXIDIZED;
    }

    public boolean isDegraded() {
        return this.getOxidationLevel().ordinal() > WeatheringCopper.WeatherState.UNAFFECTED.ordinal();
    }

    public WeatheringCopper.WeatherState getOxidationLevel() {
        return WeatheringCopper.WeatherState.values()[(Integer)this.entityData.get(OXIDATION_LEVEL)];
    }

    public void setOxidationLevel(WeatheringCopper.WeatherState oxidationLevel) {
        this.entityData.set(OXIDATION_LEVEL, (Object)oxidationLevel.ordinal());
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)(0.2f * this.getMovementSpeedModifier()));
        if (this.isOxidized()) {
            this.setWasStatue(true);
        }
        if (!this.isImmobilized()) {
            this.refreshAnimationContextTracker();
        }
        if (this.isOxidized() && this.getBrain().getMemoryInternal(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get()).isEmpty()) {
            this.getBrain().setMemory(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), (Object)true);
            this.becomeStatue();
        } else if (!this.isOxidized() && this.getBrain().getMemoryInternal(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get()).isPresent()) {
            this.getBrain().eraseMemory(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get());
            this.becomeEntity();
        }
    }

    public void setStructByLightningTicks(int structByLightningTicks) {
        this.entityData.set(STRUCT_BY_LIGHTNING_TICKS, (Object)structByLightningTicks);
    }

    public int getStructByLightningTicks() {
        return (Integer)this.entityData.get(STRUCT_BY_LIGHTNING_TICKS);
    }

    public void refreshStructByLightningTicks() {
        this.setStructByLightningTicks(this.getRandom().nextIntBetweenInclusive(1200, 2400));
    }

    public boolean isStructByLightning() {
        return this.getStructByLightningTicks() > 0;
    }

    @Nullable
    public GlobalPos getButtonPos() {
        return this.getBrain().getMemoryInternal(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get()).orElse(null);
    }

    public boolean isButtonValidToBePressed(BlockPos pos) {
        return this.level().getBlockState(pos).is(FriendsAndFoesTags.COPPER_BUTTONS);
    }

    private void becomeStatue() {
        CompoundTag entitySnapshot = this.takeEntitySnapshot();
        this.setEntitySnapshot(entitySnapshot);
    }

    private void becomeEntity() {
        CopperGolemBrain.setSpinHeadCooldown(this);
        CopperGolemBrain.setPressButtonCooldown(this);
    }

    public boolean isWaxed() {
        return (Boolean)this.entityData.get(IS_WAXED);
    }

    public void setIsWaxed(boolean isWaxed) {
        this.entityData.set(IS_WAXED, (Object)isWaxed);
    }

    public boolean wasStatue() {
        return (Boolean)this.entityData.get(WAS_STATUE);
    }

    public void setWasStatue(boolean wasStatue) {
        this.entityData.set(WAS_STATUE, (Object)wasStatue);
    }

    public boolean isImmobilized() {
        return this.isOxidized() || this.wasStatue();
    }

    public void setSpawnYaw(float yaw) {
        this.lerpYRot = yaw;
        this.yRotO = yaw;
        this.setYRot(yaw);
        this.yBodyRotO = yaw;
        this.yBodyRot = yaw;
        this.lerpYHeadRot = yaw;
        this.yHeadRotO = yaw;
        this.yHeadRot = yaw;
    }

    final class CopperGolemMoveControl
    extends MoveControl {
        public CopperGolemMoveControl(CopperGolemEntity copperGolem) {
            super((Mob)copperGolem);
        }

        public void tick() {
            if (CopperGolemEntity.this.isImmobilized()) {
                return;
            }
            super.tick();
        }
    }

    final class CopperGolemLookControl
    extends LookControl {
        public CopperGolemLookControl(CopperGolemEntity copperGolem) {
            super((Mob)copperGolem);
        }

        public void tick() {
            if (CopperGolemEntity.this.isImmobilized()) {
                return;
            }
            super.tick();
        }
    }
}

