/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerBurrowDownGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerLookAroundGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerLookAtEntityGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerMeeleAttackGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerWanderAroundFarGoal;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MaulerEntity
extends PathfinderMob
implements NeutralMob,
AnimatedEntity {
    private static final int HEALTH = 20;
    private static final float ANGERED_MOVEMENT_SPEED = 0.5f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float ATTACK_DAMAGE = 8.0f;
    private static final int MAXIMUM_STORED_EXPERIENCE_POINTS = 1395;
    public static final int MIN_TICKS_UNTIL_NEXT_BURROWING = 3000;
    public static final int MAX_TICKS_UNTIL_NEXT_BURROWING = 6000;
    private static final Predicate<Entity> PREY_PREDICATE_FILTER = entity -> {
        Slime slimeEntity;
        if (entity instanceof Slime && (slimeEntity = (Slime)entity).getSize() != 1 || entity instanceof Zombie && !((Zombie)entity).isBaby()) {
            return false;
        }
        return entity.getType().is(FriendsAndFoesTags.MAULER_PREY);
    };
    private static final String TYPE_NBT_NAME = "Type";
    private static final String STORED_EXPERIENCE_POINTS_NBT_NAME = "StoredExperiencePoints";
    private static final String IS_BURROWED_DOWN_NBT_NAME = "IsBurrowedDown";
    private static final String TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME = "TicksUntilNextBurrowingDown";
    private static final String BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME = "BurrowingDownAnimationProgress";
    private static final String BURROWED_DOWN_TICKS_NBT_NAME = "BurrowedDownTicks";
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STORED_EXPERIENCE_POINTS = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_MOVING = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_BURROWED_DOWN = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_NEXT_BURROWING_DOWN = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> BURROWING_DOWN_ANIMATION_PROGRESS = SynchedEntityData.defineId(MaulerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @Nullable
    private UUID angryAt;
    public MaulerBurrowDownGoal burrowDownGoal;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    public MaulerEntity(EntityType<? extends MaulerEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(TYPE, (Object)Type.DESERT.name());
        this.entityData.define(ANGER_TIME, (Object)0);
        this.entityData.define(STORED_EXPERIENCE_POINTS, (Object)0);
        this.entityData.define(IS_MOVING, (Object)false);
        this.entityData.define(IS_BURROWED_DOWN, (Object)false);
        this.entityData.define(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)this.getRandom().nextIntBetweenInclusive(3000, 6000));
        this.entityData.define(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
        nbt.putString(TYPE_NBT_NAME, this.getMaulerType().getName());
        nbt.putInt(STORED_EXPERIENCE_POINTS_NBT_NAME, this.getStoredExperiencePoints());
        nbt.putBoolean(IS_BURROWED_DOWN_NBT_NAME, this.isBurrowedDown());
        nbt.putInt(TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME, this.getTicksUntilNextBurrowingDown());
        nbt.putFloat(BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME, this.getBurrowingDownAnimationProgress());
        if (this.burrowDownGoal != null && this.isBurrowedDown() && this.burrowDownGoal.getBurrowedDownTicks() > 0) {
            nbt.putInt(BURROWED_DOWN_TICKS_NBT_NAME, this.burrowDownGoal.getBurrowedDownTicks());
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
        this.setType(Type.fromName(nbt.getString(TYPE_NBT_NAME)));
        this.setStoredExperiencePoints(nbt.getInt(STORED_EXPERIENCE_POINTS_NBT_NAME));
        this.setBurrowedDown(nbt.getBoolean(IS_BURROWED_DOWN_NBT_NAME));
        this.setTicksUntilNextBurrowingDown(nbt.getInt(TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME));
        this.setBurrowingDownAnimationProgress(nbt.getFloat(BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME));
        if (this.burrowDownGoal != null && this.isBurrowedDown() && nbt.contains(BURROWED_DOWN_TICKS_NBT_NAME)) {
            this.burrowDownGoal.setBurrowedDownTicks(nbt.getInt(BURROWED_DOWN_TICKS_NBT_NAME));
            this.setInvulnerable(true);
            this.setInvisible(true);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        ResourceKey biomeKey = world.getBiome(this.blockPosition()).unwrapKey().orElse(Biomes.SAVANNA);
        Type type = Type.getTypeByBiome((ResourceKey<Biome>)biomeKey);
        this.setPersistenceRequired();
        this.setType(type);
        this.setSize();
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.hasCustomName();
    }

    public static boolean canSpawn(EntityType<MaulerEntity> maulerEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(FriendsAndFoesTags.MAULERS_SPAWNABLE_ON);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MaulerMeeleAttackGoal(this, 0.5, false));
        this.goalSelector.addGoal(3, (Goal)new MaulerWanderAroundFarGoal(this, 0.6));
        this.goalSelector.addGoal(4, (Goal)new MaulerLookAtEntityGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(5, (Goal)new MaulerLookAroundGoal(this));
        this.burrowDownGoal = new MaulerBurrowDownGoal(this);
        this.goalSelector.addGoal(6, (Goal)this.burrowDownGoal);
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 10, true, true, PREY_PREDICATE_FILTER));
    }

    public void tick() {
        if (!FriendsAndFoes.getConfig().enableMauler) {
            this.discard();
        }
        this.setSize();
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        if (this.getTicksUntilNextBurrowingDown() > 0) {
            this.setTicksUntilNextBurrowingDown(this.getTicksUntilNextBurrowingDown() - 1);
        }
        this.updateBurrowingDownAnimation();
    }

    public void aiStep() {
        if (!this.level().isClientSide() && this.getBurrowingDownAnimationProgress() > 0.0f) {
            this.getNavigation().setSpeedModifier(0.0);
            this.getNavigation().stop();
        }
        super.aiStep();
        if (this.level().isClientSide()) {
            return;
        }
        this.updatePersistentAnger((ServerLevel)this.level(), true);
        this.setMoving(this.getNavigation().isInProgress());
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide() && this.burrowDownGoal.isRunning()) {
            this.burrowDownGoal.stop();
        }
        return super.hurt(source, amount);
    }

    public float getSpeed() {
        return this.isAngry() ? 0.5f : 0.3f;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Item itemInHand = itemStack.getItem();
        boolean interactionResult = false;
        if (!(this.isAngry() || itemStack.isEmpty() || !itemStack.isEnchanted() && itemInHand != Items.ENCHANTED_BOOK)) {
            interactionResult = this.tryToInteractWithEnhancedItem(player, hand, itemStack);
        } else if (!this.isAngry() && itemInHand == Items.GLASS_BOTTLE) {
            interactionResult = this.tryToInteractWithGlassBottle(player, itemStack);
        }
        if (interactionResult) {
            this.gameEvent(GameEvent.ENTITY_INTERACT, (Entity)this);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    private boolean tryToInteractWithEnhancedItem(Player player, InteractionHand hand, ItemStack itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints >= 1395) {
            return false;
        }
        if (this.level().isClientSide()) {
            return true;
        }
        int experiencePoints = this.getExperiencePoints(itemStack);
        int recalculatedExperiencePoints = storedExperiencePoints + experiencePoints;
        if (recalculatedExperiencePoints > 1395) {
            recalculatedExperiencePoints = 1395;
        }
        this.setStoredExperiencePoints(recalculatedExperiencePoints);
        if (!player.getAbilities().instabuild) {
            if (itemStack.isStackable()) {
                itemStack.shrink(1);
            } else {
                EquipmentSlot equipmentSlot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                player.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            }
        }
        this.playSound(FriendsAndFoesSoundEvents.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
        this.spawnParticles((ParticleOptions)ParticleTypes.ENCHANT, 7);
        return true;
    }

    private boolean tryToInteractWithGlassBottle(Player player, ItemStack itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints < 7) {
            return false;
        }
        if (this.level().isClientSide()) {
            return true;
        }
        int experienceBottleCount = storedExperiencePoints / 7;
        int glassBottlesCount = itemStack.getCount();
        if (experienceBottleCount > glassBottlesCount) {
            experienceBottleCount = glassBottlesCount;
        }
        itemStack.shrink(experienceBottleCount);
        ItemStack experienceBottleItemStack = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, experienceBottleCount);
        player.addItem(experienceBottleItemStack);
        this.setStoredExperiencePoints(storedExperiencePoints - experienceBottleCount * 7);
        this.playSound(SoundEvents.BOTTLE_FILL_DRAGONBREATH, 1.0f, 1.0f);
        return true;
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public static AttributeSupplier.Builder createMaulerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    public boolean isPushable() {
        return !this.isBurrowedDown() && super.isPushable();
    }

    public void doPush(Entity entity) {
        if (this.isBurrowedDown()) {
            return;
        }
        super.doPush(entity);
    }

    protected SoundEvent getAmbientSound() {
        return FriendsAndFoesSoundEvents.ENTITY_MAULER_GROWL.get();
    }

    public void playAmbientSound() {
        if (this.isAngry() && this.isMoving() || this.isBurrowedDown()) {
            return;
        }
        this.playSound(this.getAmbientSound(), 0.5f, RandomGenerator.generateFloat(0.75f, 0.85f));
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_MAULER_HURT.get();
    }

    public void playHurtSound(DamageSource source) {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.playSound(this.getHurtSound(source), 0.5f, RandomGenerator.generateFloat(0.85f, 0.95f));
    }

    protected SoundEvent getDeathSound() {
        return FriendsAndFoesSoundEvents.ENTITY_MAULER_DEATH.get();
    }

    public void playStepSound(BlockPos pos, BlockState state) {
        super.playStepSound(pos, state);
        if (this.isAngry() && this.isMoving() && this.onGround() && this.getDeltaMovement().y() <= 1.0E-4) {
            this.playSound(FriendsAndFoesSoundEvents.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
        }
    }

    public boolean doHurtTarget(Entity target) {
        if (this.isBurrowedDown()) {
            return false;
        }
        return target.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.entityData.set(ANGER_TIME, (Object)angerTime);
    }

    public void startPersistentAngerTimer() {
        int angerTime = this.getRandom().nextIntBetweenInclusive(400, 1000);
        this.setRemainingPersistentAngerTime(angerTime);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public Type getMaulerType() {
        return Type.fromName((String)this.entityData.get(TYPE));
    }

    private void setType(Type type) {
        this.entityData.set(TYPE, (Object)type.name);
    }

    public int getStoredExperiencePoints() {
        return (Integer)this.entityData.get(STORED_EXPERIENCE_POINTS);
    }

    public void setStoredExperiencePoints(int storedExperiencePoints) {
        this.entityData.set(STORED_EXPERIENCE_POINTS, (Object)storedExperiencePoints);
        this.xpReward = storedExperiencePoints;
    }

    public void setSize() {
        float size = this.getSize();
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)((int)(20.0f * size)));
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)(8.0f * (size / 2.0f)));
        this.refreshDimensions();
        this.makeBoundingBox();
    }

    public float getSize() {
        return 1.0f + (float)this.getStoredExperiencePoints() / 1395.0f * 1.25f;
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(IS_MOVING);
    }

    public void setMoving(boolean isMoving) {
        this.entityData.set(IS_MOVING, (Object)isMoving);
    }

    public boolean isBurrowedDown() {
        return (Boolean)this.entityData.get(IS_BURROWED_DOWN);
    }

    public void setBurrowedDown(boolean isBurrowedDown) {
        this.entityData.set(IS_BURROWED_DOWN, (Object)isBurrowedDown);
    }

    public int getTicksUntilNextBurrowingDown() {
        return (Integer)this.entityData.get(TICKS_UNTIL_NEXT_BURROWING_DOWN);
    }

    public void setTicksUntilNextBurrowingDown(int ticksUntilNextBurrowingDown) {
        this.entityData.set(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)ticksUntilNextBurrowingDown);
    }

    public float getBurrowingDownAnimationProgress() {
        return ((Float)this.entityData.get(BURROWING_DOWN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setBurrowingDownAnimationProgress(float burrowingDownAnimationProgress) {
        this.entityData.set(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(burrowingDownAnimationProgress));
    }

    private void updateBurrowingDownAnimation() {
        if (this.isBurrowedDown()) {
            this.setBurrowingDownAnimationProgress(Math.min(1.0f, this.getBurrowingDownAnimationProgress() + 0.04f));
        } else {
            this.setBurrowingDownAnimationProgress(Math.max(0.0f, this.getBurrowingDownAnimationProgress() - 0.04f));
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).scale(this.getSize());
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    private int getExperiencePoints(ItemStack stack) {
        int experiencePoints = 0;
        Map mappedEnchantments = EnchantmentHelper.getEnchantments((ItemStack)stack);
        for (Map.Entry enchantmentItem : mappedEnchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)enchantmentItem.getKey();
            Integer enchantmentExperiencePoints = (Integer)enchantmentItem.getValue();
            if (((Enchantment)enchantmentItem.getKey()).isCurse()) continue;
            experiencePoints += enchantment.getMinCost(enchantmentExperiencePoints.intValue());
        }
        return experiencePoints;
    }

    public void spawnParticles(ParticleOptions particleEffect, int amount) {
        Level world = this.level();
        if (world.isClientSide()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)world).sendParticles(particleEffect, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 1, this.getRandom().nextGaussian() * 0.02, this.getRandom().nextGaussian() * 0.02, this.getRandom().nextGaussian() * 0.02, 1.0);
        }
    }

    public static enum Type {
        BADLANDS("badlands"),
        DESERT("desert"),
        SAVANNA("savanna");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Type fromName(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return SAVANNA;
        }

        public static Type getTypeByBiome(ResourceKey<Biome> biome) {
            if (biome == Biomes.DESERT) {
                return DESERT;
            }
            if (biome == Biomes.BADLANDS || biome == Biomes.ERODED_BADLANDS || biome == Biomes.WOODED_BADLANDS) {
                return BADLANDS;
            }
            return SAVANNA;
        }
    }
}

