/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.api.MoobloomVariantManager;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public final class MoobloomEntity
extends Cow
implements Shearable {
    public static final String VARIANT_NBT_NAME = "Variant";
    public static final String FLOWER_NBT_NAME = "Flower";
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(MoobloomEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public MoobloomEntity(EntityType<? extends Cow> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean canSpawn(EntityType<MoobloomEntity> moobloomEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos.below()).is(Blocks.GRASS_BLOCK) && MoobloomEntity.isBrightEnoughToSpawn((BlockAndTintGetter)serverWorldAccess, (BlockPos)blockPos);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorldAccess, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        MoobloomVariant possibleMoobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getRandomBiomeSpecificMoobloomVariant(serverWorldAccess, this.blockPosition());
        if (possibleMoobloomVariant != null) {
            this.setVariant(possibleMoobloomVariant);
        } else {
            this.setVariant(MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getRandomMoobloomVariant(serverWorldAccess.getRandom()));
        }
        return super.finalizeSpawn(serverWorldAccess, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(VARIANT, (Object)MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant().getName());
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString(VARIANT_NBT_NAME, this.getVariant().getName());
        nbt.putString(FLOWER_NBT_NAME, this.getVariant().getFlowerName());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariantByName(nbt.getString(VARIANT_NBT_NAME));
        if (moobloomVariant == null) {
            moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant();
        }
        this.setVariant(moobloomVariant);
    }

    public void shear(SoundSource shearedSoundCategory) {
        Level world = this.level();
        world.playSound(null, (Entity)this, SoundEvents.MOOSHROOM_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        if (world.isClientSide()) {
            return;
        }
        ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        this.discard();
        Cow cowEntity = (Cow)EntityType.COW.create(world);
        if (cowEntity == null) {
            return;
        }
        cowEntity.setHealth(this.getHealth());
        cowEntity.copyPosition((Entity)this);
        cowEntity.yBodyRotO = this.yBodyRotO;
        cowEntity.yBodyRot = this.yBodyRot;
        cowEntity.yHeadRotO = this.yHeadRotO;
        cowEntity.yHeadRot = this.yHeadRot;
        if (this.hasCustomName()) {
            cowEntity.setCustomName(this.getCustomName());
            cowEntity.setCustomNameVisible(this.isCustomNameVisible());
        }
        if (this.isPersistenceRequired()) {
            cowEntity.setPersistenceRequired();
        }
        cowEntity.setInvulnerable(this.isInvulnerable());
        world.addFreshEntity((Entity)cowEntity);
        for (int i = 0; i < 5; ++i) {
            world.addFreshEntity((Entity)new ItemEntity(world, this.getX(), this.getY(1.0), this.getZ(), new ItemStack((ItemLike)this.getVariant().getFlower())));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getByFlowerItem(itemStack.getItem());
        if (moobloomVariant != null && moobloomVariant != this.getVariant()) {
            this.setVariant(moobloomVariant);
            this.playSound(FriendsAndFoesSoundEvents.ENTITY_MOOBLOOM_CONVERT.get(), 2.0f, 1.0f);
            boolean isClientWorld = this.level().isClientSide();
            if (!isClientWorld) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, playerx -> playerx.broadcastBreakEvent(hand));
            }
            return InteractionResult.sidedSuccess((boolean)isClientWorld);
        }
        if (itemStack.getItem() == Items.SHEARS && this.readyForShearing()) {
            this.shear(SoundSource.PLAYERS);
            this.gameEvent(GameEvent.SHEAR, (Entity)player);
            boolean isClientWorld = this.level().isClientSide();
            if (!isClientWorld) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, playerx -> playerx.broadcastBreakEvent(hand));
            }
            return InteractionResult.sidedSuccess((boolean)isClientWorld);
        }
        return super.mobInteract(player, hand);
    }

    public MoobloomEntity createChild(ServerLevel serverWorld, AgeableMob entity) {
        MoobloomVariant moobloomVariant = this.getVariant();
        if (this.getRandom().nextIntBetweenInclusive(0, 1) == 0) {
            moobloomVariant = ((MoobloomEntity)entity).getVariant();
        }
        MoobloomEntity moobloom = (MoobloomEntity)FriendsAndFoesEntityTypes.MOOBLOOM.get().create((Level)serverWorld);
        moobloom.setVariant(moobloomVariant);
        return moobloom;
    }

    public void aiStep() {
        Block blockUnderneath;
        super.aiStep();
        if (this.level().isClientSide() || this.isBaby()) {
            return;
        }
        if ((double)this.getRandom().nextFloat() <= 1.6666666E-4 && (blockUnderneath = this.level().getBlockState(new BlockPos((int)this.getX(), (int)this.getY() - 1, (int)this.getZ())).getBlock()) == Blocks.GRASS_BLOCK && this.level().isEmptyBlock(this.blockPosition())) {
            BushBlock flower = this.getVariant().getFlower();
            if (MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariants().size() == 1) {
                int flowerChance = this.getRandom().nextIntBetweenInclusive(1, 100);
                if (flowerChance >= 0 && flowerChance < 40) {
                    this.level().setBlockAndUpdate(this.blockPosition(), FriendsAndFoesBlocks.BUTTERCUP.get().defaultBlockState());
                } else if (flowerChance >= 40 && flowerChance < 80) {
                    this.level().setBlockAndUpdate(this.blockPosition(), Blocks.DANDELION.defaultBlockState());
                } else {
                    BlockState sunflowerBlockState = (BlockState)Blocks.SUNFLOWER.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                    this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)sunflowerBlockState.cycle((Property)BlockStateProperties.DOUBLE_BLOCK_HALF));
                    this.level().setBlockAndUpdate(this.blockPosition().above(), sunflowerBlockState);
                }
            } else if (flower instanceof DoublePlantBlock) {
                BlockState upperHalfBlockState = (BlockState)flower.defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)upperHalfBlockState.cycle((Property)BlockStateProperties.DOUBLE_BLOCK_HALF));
                this.level().setBlockAndUpdate(this.blockPosition().above(), upperHalfBlockState);
            } else {
                this.level().setBlockAndUpdate(this.blockPosition(), flower.defaultBlockState());
            }
        }
    }

    public void tick() {
        if (!FriendsAndFoes.getConfig().enableMoobloom) {
            this.discard();
        }
        super.tick();
    }

    private void setVariant(MoobloomVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getName());
    }

    public MoobloomVariant getVariant() {
        MoobloomVariant moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariantByName((String)this.entityData.get(VARIANT));
        if (moobloomVariant == null) {
            moobloomVariant = MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getDefaultMoobloomVariant();
        }
        return moobloomVariant;
    }
}

