/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public final class PlayerIllusionEntity
extends Mob {
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_DESPAWN;
    private static final String PLAYER_UUID_NBT_NAME = "PlayerUuid";
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID;
    private static final EntityDataAccessor<Byte> PLAYER_MODEL_PARTS;
    @Nullable
    private Player player;
    @Nullable
    private PlayerInfo playerListEntry;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    public float prevStrideDistance;
    public float strideDistance;

    public PlayerIllusionEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(PLAYER_MODEL_PARTS, (Object)0);
        this.entityData.define(TICKS_UNTIL_DESPAWN, (Object)0);
        this.entityData.define(PLAYER_UUID, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.putUUID(PLAYER_UUID_NBT_NAME, this.getPlayerUuid());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setPlayerUuid(nbt.getUUID(PLAYER_UUID_NBT_NAME));
        this.setTicksUntilDespawn(nbt.getInt(TICKS_UNTIL_DESPAWN_NBT_NAME));
    }

    public boolean shouldDropExperience() {
        return false;
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    public void aiStep() {
        boolean isPlayerNonExistingOrDead;
        super.aiStep();
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isPlayerNonExistingOrDead = this.getPlayer() != null && !this.getPlayer().isAlive();
        if (this.getTicksUntilDespawn() == 0 || isPlayerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        this.discardIllusion();
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isPartVisible(PlayerModelPart modelPart) {
        return ((Byte)this.getEntityData().get(PLAYER_MODEL_PARTS) & modelPart.getMask()) == modelPart.getMask();
    }

    @OnlyIn(value=Dist.CLIENT)
    public PlayerSkin getSkinTextures() {
        PlayerInfo playerListEntry = this.getPlayerListEntry();
        if (playerListEntry != null) {
            return playerListEntry.getSkin();
        }
        UUID uuid = this.getPlayerUuid();
        if (uuid == null) {
            uuid = this.getUUID();
        }
        return DefaultPlayerSkin.get((UUID)uuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 lerpVelocity(float tickDelta) {
        return Vec3.ZERO.lerp(this.getDeltaMovement(), (double)tickDelta);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private PlayerInfo getPlayerListEntry() {
        if (this.playerListEntry == null) {
            UUID uuid = this.getPlayerUuid();
            if (uuid == null) {
                uuid = this.getUUID();
            }
            this.playerListEntry = Minecraft.getInstance().getConnection().getPlayerInfo(uuid);
        }
        return this.playerListEntry;
    }

    @Nullable
    public UUID getPlayerUuid() {
        return ((Optional)this.entityData.get(PLAYER_UUID)).orElse(null);
    }

    public void setPlayerUuid(UUID uuid) {
        this.entityData.set(PLAYER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.entityData.get(TICKS_UNTIL_DESPAWN);
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.entityData.set(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.discard();
    }

    private void playMirrorSound() {
        this.playSound(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.getSoundVolume(), this.getVoicePitch());
    }

    public boolean tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.level().getMinBuildHeight());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)this.level()).getLogicalHeight() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.randomTeleport(x, y = (int)Mth.clamp((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    public void spawnCloudParticles() {
        this.spawnParticles(ParticleTypes.CLOUD, 16);
    }

    private void spawnParticles(SimpleParticleType particleType, int amount) {
        if (this.level().isClientSide()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)this.getCommandSenderWorld()).sendParticles((ParticleOptions)particleType, this.getRandomX(0.5), this.getRandomY() + 0.5, this.getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        PLAYER_MODEL_PARTS = SynchedEntityData.defineId(PlayerIllusionEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
        TICKS_UNTIL_DESPAWN = SynchedEntityData.defineId(PlayerIllusionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        PLAYER_UUID = SynchedEntityData.defineId(PlayerIllusionEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    }
}

