/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public final class WildfireEntity
extends Monster {
    private float damageAmountCounter = 0.0f;
    public static final float GENERIC_ATTACK_DAMAGE = 8.0f;
    public static final float GENERIC_FOLLOW_RANGE = 32.0f;
    public static final int DEFAULT_ACTIVE_SHIELDS_COUNT = 4;
    public static final int DEFAULT_TICKS_UNTIL_SHIELD_REGENERATION = 300;
    public static final int DEFAULT_SUMMONED_BLAZES_COUNT = 0;
    public static final int MAXIMUM_SUMMONED_BLAZES_COUNT = 2;
    private static final String ACTIVE_SHIELDS_NBT_NAME = "ActiveShieldsCount";
    private static final String TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME = "TicksUntilShieldRegeneration";
    private static final String SUMMONED_BLAZES_COUNT_NBT_NAME = "SummonedBlazesCount";
    private static final EntityDataAccessor<Integer> ACTIVE_SHIELDS_COUNT = SynchedEntityData.defineId(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_SHIELD_REGENERATION = SynchedEntityData.defineId(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SUMMONED_BLAZES_COUNT = SynchedEntityData.defineId(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public WildfireEntity(EntityType<? extends WildfireEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(BlockPathTypes.WATER, -1.0f);
        this.setPathfindingMalus(BlockPathTypes.LAVA, 8.0f);
        this.setPathfindingMalus(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.xpReward = 10;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setActiveShieldsCount(4);
        this.setSummonedBlazesCount(0);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return WildfireBrain.create(dynamic);
    }

    public Brain<WildfireEntity> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("wildfireBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("wildfireActivityUpdate");
        WildfireBrain.updateActivities(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public static AttributeSupplier.Builder createWildfireAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 120.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_KNOCKBACK, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(ACTIVE_SHIELDS_COUNT, (Object)4);
        this.entityData.define(TICKS_UNTIL_SHIELD_REGENERATION, (Object)300);
        this.entityData.define(SUMMONED_BLAZES_COUNT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt(ACTIVE_SHIELDS_NBT_NAME, this.getActiveShieldsCount());
        nbt.putInt(TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME, this.getTicksUntilShieldRegeneration());
        nbt.putInt(SUMMONED_BLAZES_COUNT_NBT_NAME, this.getSummonedBlazesCount());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setActiveShieldsCount(nbt.getInt(ACTIVE_SHIELDS_NBT_NAME));
        this.setTicksUntilShieldRegeneration(nbt.getInt(TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME));
        this.setSummonedBlazesCount(nbt.getInt(SUMMONED_BLAZES_COUNT_NBT_NAME));
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (state.liquid()) {
            return;
        }
        BlockState blockState = this.level().getBlockState(pos.above());
        SoundType blockSoundGroup = blockState.is(BlockTags.INSIDE_STEP_SOUND_BLOCKS) ? blockState.getSoundType() : state.getSoundType();
        this.playSound(FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_STEP.get(), blockSoundGroup.getVolume() * 0.15f, blockSoundGroup.getPitch());
    }

    public SoundEvent getShootSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHOOT.get();
    }

    public void playShootSound() {
        this.playSound(this.getShootSound(), this.getSoundVolume(), this.getVoicePitch());
    }

    public SoundEvent getShockwaveSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHOCKWAVE.get();
    }

    public void playShockwaveSound() {
        this.playSound(this.getShockwaveSound(), this.getSoundVolume(), this.getVoicePitch());
    }

    public void breakShield() {
        this.setActiveShieldsCount(this.getActiveShieldsCount() - 1);
    }

    public void regenerateShield() {
        if (this.getActiveShieldsCount() >= 4) {
            return;
        }
        this.setActiveShieldsCount(this.getActiveShieldsCount() + 1);
    }

    public int getActiveShieldsCount() {
        return (Integer)this.entityData.get(ACTIVE_SHIELDS_COUNT);
    }

    public void setActiveShieldsCount(int activeShields) {
        this.entityData.set(ACTIVE_SHIELDS_COUNT, (Object)activeShields);
    }

    public boolean hasActiveShields() {
        return this.getActiveShieldsCount() > 0;
    }

    public int getTicksUntilShieldRegeneration() {
        return (Integer)this.entityData.get(TICKS_UNTIL_SHIELD_REGENERATION);
    }

    public void setTicksUntilShieldRegeneration(int ticksUntilShieldRegeneration) {
        this.entityData.set(TICKS_UNTIL_SHIELD_REGENERATION, (Object)ticksUntilShieldRegeneration);
    }

    public void resetTicksUntilShieldRegeneration() {
        this.setTicksUntilShieldRegeneration(300);
    }

    public int getSummonedBlazesCount() {
        return (Integer)this.entityData.get(SUMMONED_BLAZES_COUNT);
    }

    public void setSummonedBlazesCount(int summonedBlazesCount) {
        this.entityData.set(SUMMONED_BLAZES_COUNT, (Object)summonedBlazesCount);
    }

    public boolean areBlazesSummoned() {
        return this.getSummonedBlazesCount() > 0;
    }

    public SoundEvent getShieldBreakSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHIELD_BREAK.get();
    }

    public void playShieldBreakSound() {
        this.playSound(this.getShieldBreakSound(), this.getSoundVolume(), this.getVoicePitch());
    }

    protected SoundEvent getAmbientSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_DEATH.get();
    }

    public SoundEvent getSummonBlazeSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SUMMON_BLAZE.get();
    }

    public void playSummonBlazeSound() {
        this.playSound(this.getSummonBlazeSound(), this.getSoundVolume(), this.getVoicePitch());
    }

    public void tick() {
        if (!FriendsAndFoes.getConfig().enableWildfire) {
            this.discard();
        }
        super.tick();
        this.setTicksUntilShieldRegeneration(this.getTicksUntilShieldRegeneration() - 1);
        if (this.getTicksUntilShieldRegeneration() == 0) {
            this.regenerateShield();
            this.resetTicksUntilShieldRegeneration();
        }
    }

    public void aiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, (double)0.6f, 1.0));
        }
        if (this.level().isClientSide()) {
            if (this.getRandom().nextInt(24) == 0 && !this.isSilent()) {
                this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, SoundEvents.BLAZE_BURN, this.getSoundSource(), 1.0f + this.getRandom().nextFloat(), this.getRandom().nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source == this.damageSources().generic()) {
            return super.hurt(source, amount);
        }
        Entity attacker = source.getEntity();
        if (source == this.damageSources().inFire() || attacker != null && attacker.getType().is(FriendsAndFoesTags.WILDFIRE_ALLIES)) {
            return false;
        }
        if (this.hasActiveShields()) {
            this.damageAmountCounter += amount;
            float shieldBreakDamageThreshold = (float)this.getAttributeValue(Attributes.MAX_HEALTH) * 0.25f;
            if (this.damageAmountCounter >= shieldBreakDamageThreshold) {
                if (attacker instanceof LivingEntity) {
                    attacker.hurt(this.damageSources().mobAttack((LivingEntity)this), 8.0f);
                }
                this.breakShield();
                this.playShieldBreakSound();
                this.damageAmountCounter = 0.0f;
            }
            amount = 0.0f;
        }
        this.resetTicksUntilShieldRegeneration();
        boolean damageResult = super.hurt(source, amount);
        if (damageResult && attacker instanceof LivingEntity) {
            WildfireBrain.onAttacked(this, (LivingEntity)attacker);
        }
        return damageResult;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }
}

