/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.beekeeper;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public final class BeekeeperWorkTask
extends WorkAtPoi {
    protected void start(ServerLevel serverWorld, Villager villagerEntity, long l) {
        super.start(serverWorld, villagerEntity, l);
        GlobalPos beehiveGlobalPos = this.getBeehiveGlobalPos(villagerEntity);
        if (beehiveGlobalPos == null) {
            return;
        }
        BlockState beehiveBlockState = serverWorld.getBlockState(beehiveGlobalPos.pos());
        if (!this.canHarvestHoney(beehiveBlockState)) {
            return;
        }
        villagerEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.SHEARS));
        villagerEntity.startUsingItem(InteractionHand.MAIN_HAND);
    }

    protected void finishRunning(ServerLevel serverWorld, Villager villagerEntity, long l) {
        villagerEntity.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        super.stop(serverWorld, (LivingEntity)villagerEntity, l);
    }

    protected void useWorkstation(ServerLevel serverWorld, Villager villagerEntity) {
        GlobalPos beehiveGlobalPos = this.getBeehiveGlobalPos(villagerEntity);
        if (beehiveGlobalPos == null) {
            return;
        }
        BlockState beehiveBlockState = serverWorld.getBlockState(beehiveGlobalPos.pos());
        if (!this.canHarvestHoney(beehiveBlockState)) {
            return;
        }
        this.harvestHoney(serverWorld, beehiveGlobalPos, beehiveBlockState);
    }

    @Nullable
    private GlobalPos getBeehiveGlobalPos(Villager entity) {
        return entity.getBrain().getMemory(MemoryModuleType.JOB_SITE).orElse(null);
    }

    private boolean canHarvestHoney(BlockState beehiveBlockState) {
        return beehiveBlockState != null && beehiveBlockState.getBlock() instanceof BeehiveBlock && (Integer)beehiveBlockState.getValue((Property)BeehiveBlock.HONEY_LEVEL) == 5;
    }

    private void harvestHoney(ServerLevel world, GlobalPos globalPos, BlockState beehiveState) {
        BlockPos blockPos = globalPos.pos();
        world.setBlock(blockPos, (BlockState)beehiveState.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)), 3);
        world.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.BEEHIVE_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
        BeehiveBlock.dropHoneycomb((Level)world, (BlockPos)blockPos);
    }
}

