/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class CrabLayEggTask
extends Behavior<CrabEntity> {
    private static final float WITHING_DISTANCE = 2.0f;

    public CrabLayEggTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), MemoryStatus.VALUE_PRESENT), 100);
    }

    protected boolean shouldRun(ServerLevel world, CrabEntity crab) {
        return crab.getBurrowSpotPos() != null && crab.isBurrowSpotAccessible(crab.getBurrowSpotPos().pos()) && crab.getBurrowSpotPos().pos().closerToCenterThan((Position)crab.position(), 2.0) && !crab.getNavigation().isInProgress();
    }

    protected void run(ServerLevel world, CrabEntity crab, long time) {
    }

    protected boolean shouldKeepRunning(ServerLevel world, CrabEntity crab, long time) {
        return true;
    }

    protected void keepRunning(ServerLevel world, CrabEntity crab, long time) {
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        if (burrowSpotPos == null || time % 5L != 0L) {
            return;
        }
        world.levelEvent(2001, burrowSpotPos.pos(), Block.getId((BlockState)world.getBlockState(burrowSpotPos.pos().below())));
    }

    protected void finishRunning(ServerLevel world, CrabEntity crab, long time) {
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        if (burrowSpotPos != null) {
            world.playSound(null, burrowSpotPos.pos(), SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
            world.setBlock(burrowSpotPos.pos(), (BlockState)FriendsAndFoesBlocks.CRAB_EGG.get().defaultBlockState().setValue((Property)TurtleEggBlock.EGGS, (Comparable)Integer.valueOf(crab.getRandom().nextInt(4) + 1)), 3);
        }
        crab.setHasEgg(false);
        crab.setInLoveTime(600);
        crab.getBrain().eraseMemory(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get());
    }
}

