/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.Nullable;

public final class CrabLocateBurrowSpotTask
extends Behavior<CrabEntity> {
    public CrabLocateBurrowSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected boolean shouldRun(ServerLevel world, CrabEntity crab) {
        return crab.isCloseToHomePos(6.0f);
    }

    protected void run(ServerLevel world, CrabEntity crab, long time) {
        BlockPos burrowSpotPos = this.findRandomBurrowSpot(crab);
        if (burrowSpotPos == null) {
            crab.setHasEgg(false);
            crab.setInLoveTime(600);
            return;
        }
        ResourceKey registryKey = crab.level().dimension();
        crab.getBrain().setMemory(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), (Object)GlobalPos.of((ResourceKey)registryKey, (BlockPos)burrowSpotPos));
    }

    private ArrayList<BlockPos> findBurrowSpots(CrabEntity crab) {
        BlockPos blockPos = crab.blockPosition();
        ArrayList<BlockPos> darkSpots = new ArrayList<BlockPos>();
        int searchDistance = 16;
        int i = 0;
        while ((double)i <= (double)searchDistance) {
            int j = 0;
            while ((double)j < (double)searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        BlockPos.MutableBlockPos possibleBurrowSpotBlockPos = new BlockPos.MutableBlockPos();
                        possibleBurrowSpotBlockPos.setWithOffset((Vec3i)blockPos, k, i - 1, l);
                        boolean isBlockWithinDistance = blockPos.closerThan((Vec3i)possibleBurrowSpotBlockPos, (double)searchDistance);
                        if (isBlockWithinDistance && crab.isBurrowSpotAccessible((BlockPos)possibleBurrowSpotBlockPos)) {
                            darkSpots.add((BlockPos)possibleBurrowSpotBlockPos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return darkSpots;
    }

    @Nullable
    private BlockPos findRandomBurrowSpot(CrabEntity crab) {
        ArrayList<BlockPos> burrowSpots = this.findBurrowSpots(crab);
        if (burrowSpots.isEmpty()) {
            return null;
        }
        return burrowSpots.get(crab.getRandom().nextInt(burrowSpots.size()));
    }
}

