/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.goal.bee;

import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.common.mixin.BeeEntityAccessor;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class BeePollinateMoobloomGoal
extends Goal {
    private final TargetingConditions VALID_MOOBLOOM_PREDICATE = TargetingConditions.forNonCombat().ignoreInvisibilityTesting();
    private final Bee beeEntity;
    private final BeeEntityAccessor beeEntityAccessor;
    private MoobloomEntity moobloom;
    private boolean running;
    private int ticks = 0;
    private int pollinationTicks = 0;
    private int lastPollinationTick = 0;

    public BeePollinateMoobloomGoal(Bee beeEntity, BeeEntityAccessor beeEntityAccessor) {
        this.beeEntity = beeEntity;
        this.beeEntityAccessor = beeEntityAccessor;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.beeEntityAccessor.getRemainingCooldownBeforeLocatingNewFlower() > 0) {
            return false;
        }
        if (this.beeEntity.isAngry()) {
            return false;
        }
        if (this.beeEntity.hasNectar()) {
            return false;
        }
        if (this.beeEntity.level().isRaining()) {
            return false;
        }
        if (this.beeEntity.getRandom().nextFloat() < 0.5f) {
            return false;
        }
        if (this.beeEntity.beePollinateGoal.isPollinating()) {
            return false;
        }
        MoobloomEntity moobloom = this.findMoobloom();
        if (moobloom == null) {
            return false;
        }
        this.moobloom = moobloom;
        Vec3 moobloomPollinationPos = this.getMoobloomPollinationPos();
        this.beeEntity.getNavigation().moveTo(moobloomPollinationPos.x(), moobloomPollinationPos.y(), moobloomPollinationPos.z(), (double)1.2f);
        return true;
    }

    public boolean canContinueToUse() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.beeEntity.isAngry()) {
            return false;
        }
        if (this.beeEntity.getCommandSenderWorld().isRaining()) {
            return false;
        }
        if (this.completedPollination()) {
            return this.beeEntity.getRandom().nextFloat() < 0.2f;
        }
        if (this.getMoobloom() == null) {
            return false;
        }
        return this.moobloom.isAlive();
    }

    public void start() {
        this.pollinationTicks = 0;
        this.ticks = 0;
        this.lastPollinationTick = 0;
        this.setIsRunning(true);
        this.beeEntity.resetTicksWithoutNectarSinceExitingHive();
    }

    public void cancel() {
        this.setIsRunning(false);
    }

    public void stop() {
        if (this.completedPollination()) {
            this.pollinate();
            this.beeEntityAccessor.invokeSetHasNectar(true);
        }
        this.setIsRunning(false);
        this.beeEntity.getNavigation().stop();
        this.beeEntityAccessor.setTicksUntilCanPollinate(200);
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks > 600) {
            this.setMoobloom(null);
            return;
        }
        Vec3 moobloomPollinationPos = this.getMoobloomPollinationPos();
        double dinstanceToMoobloom = this.beeEntity.position().distanceTo(moobloomPollinationPos);
        if (dinstanceToMoobloom >= 0.5) {
            this.beeEntity.getMoveControl().setWantedPosition(moobloomPollinationPos.x(), moobloomPollinationPos.y(), moobloomPollinationPos.z(), 0.9);
            this.beeEntity.getLookControl().setLookAt(moobloomPollinationPos.x(), this.getMoobloom().getY(), moobloomPollinationPos.z());
        }
        if (dinstanceToMoobloom <= 1.5) {
            ++this.pollinationTicks;
            if (this.beeEntity.getRandom().nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                this.lastPollinationTick = this.pollinationTicks;
                this.beeEntity.playSound(SoundEvents.BEE_POLLINATE, 1.0f, 1.0f);
            }
        }
    }

    private void pollinate() {
        for (int i = 0; i < 7; ++i) {
            double d = this.beeEntity.getRandom().nextGaussian() * 0.02;
            double e = this.beeEntity.getRandom().nextGaussian() * 0.02;
            double f = this.beeEntity.getRandom().nextGaussian() * 0.02;
            ((ServerLevel)this.beeEntity.level()).sendParticles((ParticleOptions)ParticleTypes.HEART, this.beeEntity.getRandomX(1.0), this.beeEntity.getRandomY() + 0.5, this.beeEntity.getRandomZ(1.0), 1, d, e, f, 1.0);
        }
    }

    @Nullable
    private MoobloomEntity findMoobloom() {
        List moobloomEntities = this.beeEntity.level().getNearbyEntities(MoobloomEntity.class, this.VALID_MOOBLOOM_PREDICATE, (LivingEntity)this.beeEntity, this.beeEntity.getBoundingBox().inflate(32.0));
        double d = Double.MAX_VALUE;
        MoobloomEntity closestMoobloomEntity = null;
        for (MoobloomEntity moobloomEntity : moobloomEntities) {
            if (moobloomEntity.isBaby() || !(this.beeEntity.distanceToSqr((Entity)moobloomEntity) < d)) continue;
            closestMoobloomEntity = moobloomEntity;
            d = this.beeEntity.distanceToSqr((Entity)moobloomEntity);
        }
        return closestMoobloomEntity;
    }

    private Vec3 getMoobloomPollinationPos() {
        double moobloomPollinationYPos = this.getMoobloom().getY() + (double)this.getMoobloom().getBbHeight() * 1.5;
        return new Vec3(this.getMoobloom().getX(), moobloomPollinationYPos, this.getMoobloom().getZ());
    }

    private boolean completedPollination() {
        return this.pollinationTicks > 200;
    }

    private boolean isRunning() {
        return this.running;
    }

    private void setIsRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public MoobloomEntity getMoobloom() {
        return this.moobloom;
    }

    public void setMoobloom(MoobloomEntity moobloomEntity) {
        this.moobloom = moobloomEntity;
    }
}

