/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.block.FriendsAndFoesOxidizable;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBolt.class})
public abstract class LightningEntityMixin
extends Entity {
    public LightningEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Shadow
    protected abstract BlockPos getStrikePosition();

    @Inject(at={@At(value="TAIL")}, method={"powerLightningRod()V"})
    private void friendsandfoes$powerLightningRod(CallbackInfo ci) {
        BlockPos blockPos = this.getStrikePosition();
        BlockState blockState = this.level().getBlockState(blockPos);
        if (blockState.is(FriendsAndFoesTags.LIGHTNING_RODS)) {
            this.level().setBlockAndUpdate(blockPos, FriendsAndFoesOxidizable.getUnaffectedOxidationState(this.level().getBlockState(blockPos)));
            ((LightningRodBlock)this.level().getBlockState(blockPos).getBlock()).onLightningStrike(blockState, this.level(), blockPos);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"randomWalkCleaningCopper(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos$MutableBlockPos;I)V"})
    private static void friendsandfoes$cleanOxidationAround(Level world, BlockPos pos, BlockPos.MutableBlockPos mutablePos, int count, CallbackInfo ci) {
        Optional<BlockPos> optional;
        mutablePos.set((Vec3i)pos);
        for (int i = 0; i < count && (optional = LightningEntityMixin.friendsandfoes$cleanOxidationAround(world, (BlockPos)mutablePos)).isPresent(); ++i) {
            mutablePos.set((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> friendsandfoes$cleanOxidationAround(Level world, BlockPos pos) {
        BlockPos blockPos;
        BlockState blockState;
        Iterator var2 = BlockPos.randomInCube((RandomSource)world.getRandom(), (int)10, (BlockPos)pos, (int)1).iterator();
        do {
            if (var2.hasNext()) continue;
            return Optional.empty();
        } while (!((blockState = world.getBlockState(blockPos = (BlockPos)var2.next())).getBlock() instanceof WeatheringCopper));
        BlockPos finalBlockPos = blockPos;
        FriendsAndFoesOxidizable.getDecreasedOxidationState(blockState).ifPresent(state -> world.setBlockAndUpdate(finalBlockPos, state));
        world.levelEvent(3002, blockPos, -1);
        return Optional.of(blockPos);
    }
}

