/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TemptGoal.class})
public abstract class TemptGoalMixin {
    @Shadow
    @Final
    private double speedModifier;
    @Shadow
    private boolean isRunning;
    @Final
    @Shadow
    protected PathfinderMob mob;
    @Final
    @Shadow
    private TargetingConditions targetingConditions;
    @Nullable
    private TuffGolemEntity closestTuffGolem;
    private double lastTuffGolemX;
    private double lastTuffGolemY;
    private double lastTuffGolemZ;
    private double lastTuffGolemPitch;
    private double lastTuffGolemYaw;

    @Final
    @Shadow
    protected abstract boolean canScare();

    @Inject(method={"canUse()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void friendsandfoes_canStart(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            cir.setReturnValue((Object)this.friendsandfoes_canStartWithReturn());
        }
    }

    private boolean friendsandfoes_canStartWithReturn() {
        this.closestTuffGolem = (TuffGolemEntity)this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(TuffGolemEntity.class, this.mob.getBoundingBox().inflate(16.0, 3.0, 16.0), livingEntity -> true), this.targetingConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ());
        return this.closestTuffGolem != null;
    }

    @Inject(method={"canContinueToUse()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void friendsandfoes_shouldContinue(CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.closestTuffGolem != null) {
            if (this.canScare()) {
                if (this.mob.distanceToSqr((Entity)this.closestTuffGolem) < 36.0) {
                    if (this.closestTuffGolem.distanceToSqr(this.lastTuffGolemX, this.lastTuffGolemY, this.lastTuffGolemZ) > 0.010000000000000002) {
                        cir.setReturnValue((Object)false);
                    }
                    if (Math.abs((double)this.closestTuffGolem.getXRot() - this.lastTuffGolemPitch) > 5.0 || Math.abs((double)this.closestTuffGolem.getYRot() - this.lastTuffGolemYaw) > 5.0) {
                        cir.setReturnValue((Object)false);
                    }
                } else {
                    this.lastTuffGolemX = this.closestTuffGolem.getX();
                    this.lastTuffGolemY = this.closestTuffGolem.getY();
                    this.lastTuffGolemZ = this.closestTuffGolem.getZ();
                }
                this.lastTuffGolemPitch = this.closestTuffGolem.getXRot();
                this.lastTuffGolemYaw = this.closestTuffGolem.getYRot();
            }
            cir.setReturnValue((Object)this.friendsandfoes_canStartWithReturn());
        }
    }

    @Inject(method={"start()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void friendsandfoes_start(CallbackInfo ci) {
        if (this.closestTuffGolem != null) {
            this.lastTuffGolemX = this.closestTuffGolem.getX();
            this.lastTuffGolemY = this.closestTuffGolem.getY();
            this.lastTuffGolemZ = this.closestTuffGolem.getZ();
            this.isRunning = true;
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"stop()V"})
    private void friendsandfoes_stop(CallbackInfo ci) {
        this.closestTuffGolem = null;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"}, cancellable=true)
    public void friendsandfoes_tick(CallbackInfo ci) {
        if (this.closestTuffGolem != null) {
            this.mob.getLookControl().setLookAt((Entity)this.closestTuffGolem, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
            if (this.mob.distanceToSqr((Entity)this.closestTuffGolem) < 6.25) {
                this.mob.getNavigation().stop();
            } else {
                this.mob.getNavigation().moveTo((Entity)this.closestTuffGolem, this.speedModifier);
            }
            ci.cancel();
        }
    }
}

