/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.platform.neoforge;

import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public final class PacketChannelManagerImpl {
    private static final Map<ResourceLocation, PacketRegistration<?>> PACKETS = new HashMap();
    private static boolean frozen = false;

    public static void registerPayloads(RegisterPayloadHandlerEvent event) {
        frozen = true;
        IPayloadRegistrar registrar = event.registrar("friendsandfoes");
        for (PacketRegistration<?> registration : PACKETS.values()) {
            registration.register(registrar);
        }
    }

    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Preconditions.checkState((!frozen ? 1 : 0) != 0, (Object)"Packets were already registered with the platform");
        Preconditions.checkState((!PACKETS.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate packet id %s", (Object)id);
        PACKETS.put(id, new PacketRegistration<T>(id, handler, packetClass, PacketFlow.CLIENTBOUND));
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Preconditions.checkState((!frozen ? 1 : 0) != 0, (Object)"Packets were already registered with the platform");
        Preconditions.checkState((!PACKETS.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate packet id %s", (Object)id);
        PACKETS.put(id, new PacketRegistration<T>(id, handler, packetClass, PacketFlow.SERVERBOUND));
    }

    public static <T extends Packet<T>> void sendToServer(ResourceLocation name, T packet) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PayloadWrapper<T>(packet)});
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation name, T packet, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new PayloadWrapper<T>(packet)});
        }
    }

    private record PacketRegistration<T extends Packet<T>>(ResourceLocation packetId, PacketHandler<T> packetHandler, Class<T> packetClass, PacketFlow side) {
        public void register(IPayloadRegistrar registrar) {
            registrar.play(this.packetId, this::decode, builder -> {
                if (this.side.isClientbound()) {
                    builder.client(this::handlePacketOnMainThread);
                } else if (this.side.isServerbound()) {
                    builder.server(this::handlePacketOnMainThread);
                }
            });
        }

        private PayloadWrapper<T> decode(FriendlyByteBuf buffer) {
            return new PayloadWrapper<T>(this.packetHandler.decode(buffer));
        }

        private void handlePacketOnMainThread(PayloadWrapper<T> payload, PlayPayloadContext context) {
            Player player = context.player().orElse(null);
            Level level = context.level().orElse(null);
            context.workHandler().execute(() -> {
                Object packet = payload.packet();
                packet.getHandler().handle(packet).apply(player, level);
            });
        }
    }

    private record PayloadWrapper<T extends Packet<T>>(T packet) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf buffer) {
            this.packet.getHandler().encode(this.packet, buffer);
        }

        public ResourceLocation id() {
            return this.packet.getID();
        }
    }
}

