/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.world.processor;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesStructureProcessorTypes;
import com.mojang.serialization.Codec;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class IllusionerShackBrewingStandProcessor
extends StructureProcessor {
    public static final IllusionerShackBrewingStandProcessor INSTANCE = new IllusionerShackBrewingStandProcessor();
    public static final Codec<IllusionerShackBrewingStandProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader world, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings structurePlacementData) {
        if (currentBlockInfo.state().getBlock() != Blocks.BREWING_STAND) {
            return currentBlockInfo;
        }
        RandomSource random = structurePlacementData.getRandom(currentBlockInfo.pos());
        CompoundTag nbt = currentBlockInfo.nbt();
        ListTag itemsListNbt = nbt.getList("Items", 10);
        int randomNumber = random.nextInt(2);
        switch (randomNumber) {
            case 0: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:golden_carrot", "minecraft:night_vision", random);
                break;
            }
            case 1: {
                this.addBrewingRecipe(itemsListNbt, "minecraft:fermented_spider_eye", "minecraft:invisibility", random);
            }
        }
        currentBlockInfo = new StructureTemplate.StructureBlockInfo(currentBlockInfo.pos(), currentBlockInfo.state(), nbt);
        return currentBlockInfo;
    }

    private void addBrewingRecipe(ListTag itemsListTag, String inputItemId, String outputPotionId, RandomSource randomSource) {
        itemsListTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), itemTag -> this.putInputItem((CompoundTag)itemTag, inputItemId, (byte)(randomSource.nextInt(1) + 2)))));
        itemsListTag.add((Object)((Tag)Util.make((Object)new CompoundTag(), itemTag -> {
            this.putPotionInSlot((CompoundTag)itemTag, (byte)1, outputPotionId);
            if (randomSource.nextFloat() < 0.5f) {
                this.putPotionInSlot((CompoundTag)itemTag, (byte)0, outputPotionId);
            }
            if (randomSource.nextFloat() < 0.5f) {
                this.putPotionInSlot((CompoundTag)itemTag, (byte)2, outputPotionId);
            }
        })));
    }

    private void putInputItem(CompoundTag itemTag, String itemId, byte count) {
        itemTag.putByte("Slot", (byte)3);
        itemTag.putString("id", itemId);
        itemTag.putByte("Count", count);
    }

    private void putPotionInSlot(CompoundTag itemTag, byte slot, String potionId) {
        itemTag.putByte("Slot", slot);
        itemTag.putString("id", "minecraft:potion");
        itemTag.putByte("Count", (byte)1);
        itemTag.put("tag", (Tag)Util.make((Object)new CompoundTag(), potionTag -> potionTag.putString("Potion", potionId)));
    }

    protected StructureProcessorType<?> getType() {
        return FriendsAndFoesStructureProcessorTypes.ILLUSIONER_SHACK_BREWING_STAND_PROCESSOR.get();
    }
}

