/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.block.CrabEggBlock;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.CrabAnimations;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CrabBrain;
import com.faboslav.friendsandfoes.common.entity.ai.control.WallClimbNavigation;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.pose.CrabEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends class_1429
implements class_1432,
AnimatedEntity {
    private static final float MOVEMENT_SPEED = 0.225f;
    private static final String SIZE_NBT_NAME = "Size";
    private static final String HOME_NBT_NAME = "Home";
    private static final String HOME_NBT_NAME_X = "x";
    private static final String HOME_NBT_NAME_Y = "y";
    private static final String HOME_NBT_NAME_Z = "z";
    private static final String HAS_EGG_NBT_NAME = "HasEgg";
    private AnimationContextTracker animationContextTracker;
    private static final class_2940<Integer> POSE_TICKS = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_CLIMBING_WALL = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> SIZE = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<class_2487> HOME = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13318);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_DANCING = class_2945.method_12791(CrabEntity.class, (class_2941)class_2943.field_13323);
    private int climbingTicks = 0;

    public CrabEntity(class_1299<? extends CrabEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.setPose(CrabEntityPose.IDLE);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_8, -1.0f);
        this.method_5941(class_7.field_23, -1.0f);
        this.method_5941(class_7.field_15, -1.0f);
        this.method_49477(0.0f);
        this.field_6206 = new CrabLookControl(this, 10);
        this.field_6189 = new CrabWallClimbNavigation((class_1308)this, world);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_1315 superEntityData = super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        this.setHome(this.getNewHome());
        this.setSize(CrabSize.getRandomCrabSize(world.method_8409()));
        this.setPose(CrabEntityPose.IDLE);
        CrabBrain.setWaveCooldown(this);
        return superEntityData;
    }

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
                this.animationContextTracker.add(keyframeAnimation);
            }
            this.animationContextTracker.add(this.getMovementAnimation());
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return CrabAnimations.ANIMATIONS;
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return CrabAnimations.WALK;
    }

    public boolean method_5675() {
        return !this.method_5681();
    }

    public boolean method_35053() {
        return this.method_5681();
    }

    protected void method_6043() {
    }

    public boolean method_6581() {
        return this.method_6101();
    }

    public float method_6029() {
        if (this.method_6109()) {
            return 0.1125f;
        }
        return 0.225f;
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return (Integer)this.field_6011.method_12789(POSE_TICKS);
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.field_6011.method_12778(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(POSE_TICKS, (Object)0);
        this.field_6011.method_12784(IS_CLIMBING_WALL, (Object)false);
        this.field_6011.method_12784(SIZE, (Object)CrabSize.getDefaultCrabSize().getName());
        this.field_6011.method_12784(HOME, (Object)new class_2487());
        this.field_6011.method_12784(HAS_EGG, (Object)false);
        this.field_6011.method_12784(IS_DANCING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(SIZE_NBT_NAME, this.getSize().getName());
        nbt.method_10566(HOME_NBT_NAME, (class_2520)this.getHome());
        nbt.method_10556(HAS_EGG_NBT_NAME, this.hasEgg());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        CrabSize crabSize = CrabSize.getCrabSizeByName(nbt.method_10558(SIZE_NBT_NAME));
        if (crabSize == null) {
            crabSize = CrabSize.getDefaultCrabSize();
        }
        this.setSize(crabSize);
        this.setHome(nbt.method_10562(HOME_NBT_NAME));
        this.setHasEgg(nbt.method_10577(HAS_EGG_NBT_NAME));
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CrabBrain.create(dynamic);
    }

    public class_4095<CrabEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public static class_5132.class_5133 createCrabAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, (double)0.225f).method_26868(class_5134.field_23721, 2.0);
    }

    protected float method_5867() {
        return this.field_5994 + 0.175f;
    }

    public boolean method_6101() {
        return this.climbingTicks > 8 && this.isClimbingWall();
    }

    public boolean isClimbingWall() {
        return (Boolean)this.field_6011.method_12789(IS_CLIMBING_WALL);
    }

    public void setClimbingWall(boolean isClimbingWall) {
        this.field_6011.method_12778(IS_CLIMBING_WALL, (Object)isClimbingWall);
    }

    protected class_3414 method_6011(class_1282 source) {
        return FriendsAndFoesSoundEvents.ENTITY_CRAB_HURT.get();
    }

    protected class_3414 method_6002() {
        return FriendsAndFoesSoundEvents.ENTITY_CRAB_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (!this.method_24828() && state.method_51176()) {
            return;
        }
        this.method_5783(FriendsAndFoesSoundEvents.ENTITY_CRAB_STEP.get(), 0.15f, 1.0f + this.field_5974.method_43057() * 0.2f);
    }

    public void method_5773() {
        if (!this.method_37908().method_8608() && !FriendsAndFoes.getConfig().enableCrab) {
            this.method_31472();
        }
        this.updateKeyframeAnimations();
        this.calculateSize();
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            this.setClimbingWall(this.field_5976);
        }
        if (this.isClimbingWall()) {
            ++this.climbingTicks;
            class_2680 blockStateAtPos = this.method_36601();
            if (this.isMoving() && !blockStateAtPos.method_51176() && this.climbingTicks % 6 == 0) {
                this.method_5712(this.method_24515(), blockStateAtPos);
            }
        } else {
            this.climbingTicks = 0;
        }
        if (this.method_6101()) {
            class_243 velocity = this.method_18798();
            this.method_18800(velocity.field_1352, velocity.field_1351 * (double)0.33f, velocity.field_1350);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.field_6012 % 5 == 0) {
            boolean isDancing = false;
            for (class_2338 blockPos : class_2338.method_25996((class_2338)this.method_24515(), (int)7, (int)7, (int)7)) {
                class_2586 possibleJukeboxBlockEntity;
                class_2338.class_2339 possibleJukeboxBlockPos = blockPos.method_25503();
                class_2680 possibleJukeboxBlockState = this.method_37908().method_8320((class_2338)possibleJukeboxBlockPos);
                if (!possibleJukeboxBlockState.method_27852(class_2246.field_10223) || !possibleJukeboxBlockState.method_31709() || !((possibleJukeboxBlockEntity = this.method_37908().method_8321((class_2338)possibleJukeboxBlockPos)) instanceof class_2619) || !((class_2619)possibleJukeboxBlockEntity).method_44373()) continue;
                isDancing = true;
                break;
            }
            this.setIsDancing(isDancing);
        }
    }

    private void updateKeyframeAnimations() {
        KeyframeAnimation keyframeAnimationToStart;
        if (!this.method_37908().method_8608()) {
            this.updateKeyframeAnimationTicks();
        }
        if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
            this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
        }
    }

    @Nullable
    private KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.isInPose(CrabEntityPose.IDLE) && !this.isMoving()) {
            keyframeAnimation = CrabAnimations.IDLE;
        } else if (this.isInPose(CrabEntityPose.WAVE)) {
            keyframeAnimation = CrabAnimations.WAVE;
        } else if (this.isInPose(CrabEntityPose.DANCE)) {
            keyframeAnimation = CrabAnimations.DANCE;
        }
        return keyframeAnimation;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.method_37908().method_8608()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        this.startKeyframeAnimation(keyframeAnimationToStart, this.field_6012);
    }

    public void startWaveAnimation() {
        if (this.isInPose(CrabEntityPose.WAVE)) {
            return;
        }
        this.setPose(CrabEntityPose.WAVE);
    }

    public void startDanceAnimation() {
        if (this.isInPose(CrabEntityPose.DANCE)) {
            return;
        }
        this.setPose(CrabEntityPose.DANCE);
    }

    public void setPose(CrabEntityPose pose) {
        if (this.method_37908().method_8608()) {
            return;
        }
        this.method_18380(pose.get());
    }

    public boolean method_41328(class_4050 pose) {
        return this.method_18376() == pose;
    }

    public boolean isInPose(CrabEntityPose pose) {
        return this.method_18376() == pose.get();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("crabBrain");
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("crabMemoryUpdate");
        CrabBrain.updateMemories(this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("crabActivityUpdate");
        CrabBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_6109() && this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
            this.method_5870((class_1935)FriendsAndFoesItems.CRAB_CLAW.get(), 1);
        }
    }

    public boolean isMoving() {
        return (this.method_24828() || this.method_6101()) && this.method_18798().method_1027() >= 1.0E-4;
    }

    public static boolean canSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(FriendsAndFoesTags.CRABS_SPAWNABLE_ON) && CrabEggBlock.isSuitableBelow((class_1922)world, pos) && CrabEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public boolean method_6481(class_1799 itemStack) {
        return CrabBrain.getTemptItems().method_8093(itemStack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 entity) {
        CrabEntity crab = (CrabEntity)FriendsAndFoesEntityTypes.CRAB.get().method_5883((class_1937)serverWorld);
        CrabBrain.setWaveCooldown(crab);
        return crab;
    }

    public void method_24650(class_3218 world, class_1429 mate) {
        class_3222 serverPlayerEntity = this.method_6478();
        if (serverPlayerEntity == null && mate.method_6478() != null) {
            serverPlayerEntity = mate.method_6478();
        }
        if (serverPlayerEntity != null) {
            serverPlayerEntity.method_7281(class_3468.field_15410);
            class_174.field_1190.method_855(serverPlayerEntity, (class_1429)this, mate, null);
        }
        this.setHasEgg(true);
        this.method_6477();
        mate.method_6477();
        class_5819 random = this.method_6051();
        if (this.method_37908().method_8450().method_8355(class_1928.field_19391)) {
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), random.method_43048(7) + 1));
        }
    }

    @Nullable
    public class_4208 getBurrowSpotPos() {
        return this.method_18868().method_46873(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()).orElse(null);
    }

    public boolean isBurrowSpotAccessible(class_2338 pos) {
        class_1937 world = this.method_37908();
        boolean isBlockSand = world.method_8320(pos.method_10074()).method_26164(FriendsAndFoesTags.CRAB_BURROW_SPOT_BLOCKS);
        boolean isBlockAccessible = world.method_22347(pos) && world.method_22347(pos.method_10084());
        return isBlockSand && isBlockAccessible;
    }

    public class_2487 getNewHome() {
        class_2487 home = new class_2487();
        home.method_10549(HOME_NBT_NAME_X, this.method_19538().method_10216());
        home.method_10549(HOME_NBT_NAME_Y, this.method_19538().method_10214());
        home.method_10549(HOME_NBT_NAME_Z, this.method_19538().method_10215());
        return home;
    }

    public void setHome(class_2487 home) {
        this.field_6011.method_12778(HOME, (Object)home);
    }

    public class_2487 getHome() {
        return (class_2487)this.field_6011.method_12789(HOME);
    }

    public class_243 getHomePos() {
        return new class_243(this.getHome().method_10574(HOME_NBT_NAME_X), this.getHome().method_10574(HOME_NBT_NAME_Y), this.getHome().method_10574(HOME_NBT_NAME_Z));
    }

    public boolean isAtHomePos() {
        return this.method_5707(this.getHomePos()) < 0.1;
    }

    public boolean isCloseToHomePos(float distance) {
        return this.method_5707(this.getHomePos()) < (double)distance;
    }

    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDancing() {
        return (Boolean)this.field_6011.method_12789(IS_DANCING);
    }

    public void setIsDancing(boolean isDancing) {
        this.field_6011.method_12778(IS_DANCING, (Object)isDancing);
    }

    private void setSize(CrabSize size) {
        this.field_6011.method_12778(SIZE, (Object)size.getName());
        this.calculateSize();
    }

    private void calculateSize() {
        this.method_18382();
        this.method_33332();
    }

    public CrabSize getSize() {
        return CrabSize.getCrabSizeByName((String)this.field_6011.method_12789(SIZE));
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383(this.getSize().scaleModifier);
    }

    class CrabLookControl
    extends class_1332 {
        public CrabLookControl(CrabEntity crab, int yawAdjustThreshold) {
            super((class_1308)crab, yawAdjustThreshold);
        }

        public void method_6231() {
            if (!CrabEntity.this.method_6101()) {
                super.method_6231();
            }
        }
    }

    class CrabWallClimbNavigation
    extends WallClimbNavigation {
        public CrabWallClimbNavigation(class_1308 mobEntity, class_1937 world) {
            super(mobEntity, world);
        }

        @Override
        public void method_6360() {
            if (!CrabEntity.this.isDancing()) {
                super.method_6360();
            }
        }
    }

    public static enum CrabSize {
        SMALL("small", 0.9f),
        MEDIUM("medium", 0.95f),
        BIG("big", 1.0f);

        private final String name;
        private final float scaleModifier;

        private CrabSize(String name, float scaleModifier) {
            this.name = name;
            this.scaleModifier = scaleModifier;
        }

        public String getName() {
            return this.name;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }

        @Nullable
        public static CrabSize getCrabSizeByName(String name) {
            for (CrabSize crabSize : CrabSize.values()) {
                if (!Objects.equals(crabSize.getName(), name)) continue;
                return crabSize;
            }
            return null;
        }

        public static CrabSize getDefaultCrabSize() {
            return BIG;
        }

        public static CrabSize getRandomCrabSize(class_5819 random) {
            CrabSize[] values = CrabSize.values();
            int min = 0;
            int max = values.length - 1;
            return values[random.method_43048(max - min + 1) + min];
        }
    }
}

