/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.network.packet;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.api.MoobloomVariantManager;
import com.faboslav.friendsandfoes.common.events.lifecycle.DatapackSyncEvent;
import com.faboslav.friendsandfoes.common.network.MessageHandler;
import com.faboslav.friendsandfoes.common.network.base.Packet;
import com.faboslav.friendsandfoes.common.network.base.PacketContext;
import com.faboslav.friendsandfoes.common.network.base.PacketHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record MoobloomVariantsSyncPacket(List<MoobloomVariant> moobloomVariants) implements Packet<MoobloomVariantsSyncPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final class_2960 ID = FriendsAndFoes.makeID("moobloom_variants_sync_packet");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(DatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new MoobloomVariantsSyncPacket(MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.getMoobloomVariants()), (class_1657)event.player());
    }

    @Override
    public class_2960 getID() {
        return ID;
    }

    @Override
    public PacketHandler<MoobloomVariantsSyncPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<MoobloomVariantsSyncPacket> {
        @Override
        public PacketContext handle(MoobloomVariantsSyncPacket packet) {
            return (player, level) -> MoobloomVariantManager.MOOBLOOM_VARIANT_MANAGER.setMoobloomVariants(packet.moobloomVariants());
        }

        @Override
        public MoobloomVariantsSyncPacket decode(class_2540 buf) {
            ArrayList<MoobloomVariant> parsedMoobloomVariants = new ArrayList<MoobloomVariant>();
            class_2487 data = buf.method_10798();
            if (data == null) {
                FriendsAndFoes.getLogger().error("Moobloom Variant packet is empty");
                return new MoobloomVariantsSyncPacket(parsedMoobloomVariants);
            }
            class_2499 moobloomVariants = data.method_10554("moobloom_variants", 10);
            for (class_2520 moobloomVariant : moobloomVariants) {
                DataResult parsedMoobloomVariant = MoobloomVariant.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)moobloomVariant);
                parsedMoobloomVariant.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to parse Moobloom Variant packet entry: {}", error));
                parsedMoobloomVariant.result().ifPresent(parsedMoobloomVariants::add);
            }
            return new MoobloomVariantsSyncPacket(parsedMoobloomVariants);
        }

        @Override
        public void encode(MoobloomVariantsSyncPacket packet, class_2540 buf) {
            class_2487 data = new class_2487();
            class_2499 parsedMoobloomVariants = new class_2499();
            for (MoobloomVariant moobloomVariant : packet.moobloomVariants()) {
                DataResult parsedMoobloomVariant = MoobloomVariant.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)moobloomVariant);
                parsedMoobloomVariant.error().ifPresent(error -> FriendsAndFoes.getLogger().error("Failed to encode Moobloom Variant packet entry: {}", error));
                parsedMoobloomVariant.result().ifPresent(arg_0 -> parsedMoobloomVariants.add(arg_0));
            }
            data.method_10566("moobloom_variants", (class_2520)parsedMoobloomVariants);
            buf.method_10794((class_2520)data);
        }
    }
}

